---
title: Factoring in Algebra
---
## Factoring in Algebra

Factoring is how you take a quadratic in standard form and put it in factored form. The standard form for a quadratic is normally shown as ax<sup>2</sup> + bx + c where a and b are coefficients and c is a constant. Factored form is normally shown as (x - d)(x - t) where d and t are both coefficients.

## Factoring in Your Head

This method of factoring usually works best when a = 1. To do this when a = 1 you look at what two numbers add to equal b while also multiplying to c. Those two numbers will then be equal to d and t.

#### Example 1:
x<sup>2</sup> + 2x + 1
Here you have to look for two numbers that multiply to 1 and add to 2. Those two numbers are 1 and 1. Then you put those numbers into the factored form like this:
(x + 1)(x + 1)

#### Example 2:
x<sup>2</sup> + 7x + 12
Here you have to look for two numbers that multiply to 12 and add to 7. Those two numbers are 3 and 4. Then you put those numbers into the factored form like this:
(x + 3)(x + 4).

#### Example 3:
2x<sup>2</sup> + 3x + 1 
In some cases, the quadratic co-efficient, which is the value of a in ax<sup>2</sup>, can be greater than 1, where we need to consider how to create a number 3, through the combination of addition and multiplication with the factors of the quadratic co-efficient, and the co-efficient. So we consider the factors of 2 and 1 in '2' for the quadratic co-efficient, and the factors of 1 and 1 for the '1' in the co-efficient. We are required to multiply one factor of the quadratic co-efficient to another factor of the co-efficient, and consider the other case as well. So we multiply 2 from the quadratic co-efficient and 1 from the co-efficient, to receive a value of 2, while we multiply 1 from the quadratic co-efficient and 1 from the co-efficient, to receive a value of 1. Afterwards, we add the values of 2 and 1 to receive a value of 3, which corresponds to the linear co-efficient of 3x in the equation. Hence, you put these numbers into the factored form like this:
(2x+1)(x+1).

#### Example 4:
6x<sup>2</sup> + 11x + 4 
In some cases, the quadratic co-efficient, which is the value of a in ax<sup>2</sup>, can be greater than 1, where we need to consider how to create a number 11, through the combination of addition and multiplication with the factors of the quadratic co-efficient, and the co-efficient. So we consider the factors of 3 and 2 in '6' for the quadratic co-efficient, and the factors of 4 and 1 for the '4' in the co-efficient. We are required to multiply one factor of the quadratic co-efficient to another factor of the co-efficient, and consider the other case as well. So we multiply 2 from the quadratic co-efficient and 4 from the co-efficient, to receive a value of 8, while we multiply 3 from the quadratic co-efficient and 1 from the co-efficient, to receive a value of 3. Afterwards, we add the values of 8 and 3 to receive a value of 3, which corresponds to the linear co-efficient of 11x in the equation. Hence, you put these numbers into the factored form like this:
(2x+1)(3x+4)
