---
title: Fibonacci Number
---
## Fibonacci Number

Fibonacci Number is a term of the <i>Fibonacci sequence</i>, probably one of the most famous
sequences out there. In this sequence, each new number is the sum of the previous two numbers:
- F(n) = F(n - 1) + F(n - 2).

So let's take it from the start, and it starts with 0. The next number will be the sum of the
previous two numbers, which will be 1. Therefore the next number will also be 1.
Then comes the third number, which will be the sum of 1 and 1, which is 2.
Then comes 1 and 2, which is 3, 2 and 3, which is 5, 3 and 5, which is 8, and so on.

This sequence is seen in many places in nature, like the shell of a snail or the
spiral patterns of a sunflower.

The initial values are :

0, 1, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144, 233...

If you desire to make a program which finds the fibonacci-number after x iterations, make sure you
have a large enough boundary. The value grows exponentially quick, and will therefore take more
space than expected.

Something that is fascinating about the Fibonnaci sequence is its existence in nature. It can be found in flower petals, seed heads, pinecones, shells, hurricanes, and so much more.

### More Information:
* A lot of information about Fibonacci numbers, including the proof of Binet's formula, can be found [here](https://en.wikipedia.org/wiki/Fibonacci_number).
* [The On-Line Encyclopedia of Integer Sequences: Fibonacci numbers](http://oeis.org/A000045)
* [The Fibonacci sequence as it is found in the musical scale.](https://www.youtube.com/watch?v=2pbEarwdusc)
* [The Fibonacci sequence in nature](https://io9.gizmodo.com/5985588/15-uncanny-examples-of-the-golden-ratio-in-nature)
