---
title: Fourier Series
---
## Fourier Series

Fourier Series represent some function as a sum of sines and cosines. This can be done by applying a Fourier Transform on some functions. There are many different kinds of Fourier Transforms, such as continuous, discrete, finite, and infinite. Here's a simple usecase for a Fourier Transform: Say you would like to approximate a square wave algebraically. The best way to do this would be to apply a Fourier Transform, yielding a Fourier Series. This new series can be approximated using Taylor Series, so the sum of sines and cosines will become a sum of polynomials, which is easy for a computer to calculate. Fourier Series are studied today, in a field called "Fourier Analysis". For an intuitive understanding of the transform, read the "BetterExplained" article in the information section below. For a jumping off point into the academic/engineering applications of Fourier Series, see the Wikipedia article below.

#### More Information:
* [Wikipedia on Fourier Series](https://en.wikipedia.org/wiki/Fourier_series)
* [Wolfram on Fourier Series](http://mathworld.wolfram.com/FourierSeries.html)
* [Fourier Series: Better Explained](https://betterexplained.com/articles/an-interactive-guide-to-the-fourier-transform/)
* [StackExchange on the Fourier Transform](https://math.stackexchange.com/questions/1002/fourier-transform-for-dummies)

