---
title: Fractions
---

## Fractions

A fraction represents part of a whole number. These numbers can be represented using decimals (e.g. 0.1), percentages (e.g. 10%), exponents/indices (e.g. 10^(-1)) or fractions (e.g. 1/10).

A fraction normally has two parts which are separated by a line:

* Numerator: Represents the number of equal parts making up the fraction; the number above or to the left of the line.
* Denominator: Represents the whole, the non-zero number by which the numerator is divided; the number below or to the right of the line.

A *simple* fraction is one where the numerator and denominator are both integers, e.g., 1/2 or -2/3. A *complex* fraction is one where the numerator and denominator can also be fractions themselves, e.g., (1/2)/(3/4) or -1/(2/3), while a *mixed* fraction is one where we combine an integer and a simple fraction, e.g., 1 1/2, that is 1 + 1/2.

A *proper* fraction is one where the numerator and denominator are both positive, and the numerator is less than the denominator. For example, 1/2, 2/3 and 4/7. Every other simple fraction is called *improper*, e.g., -1/2, 7/3 and -3/2.

Any fraction represents a real number and therefore has a decimal representation. These are precisely the decimal numbers that terminate with a repeating pattern, e.g., 1/3 = 0.333... and -3/2 = -1.5 (with 0s repeating).
