---
title: Hexagon
---
## Hexagon

A hexagon is a polygon with six sides. Each internal angle in a regular polygon is 120°. Since there are 6 internal angles, the sum of the internal angles totals 720°. In addition, each exterior angle of a regular polygon is 60°, so the sum of the exterior angles is 360°.

<img src=https://upload.wikimedia.org/wikipedia/commons/thumb/c/cb/Hexagon_1.svg/2000px-Hexagon_1.svg.png  alt="a regular hexagon" height="150" />

### Regular vs Irregular Hexagons
You can tell if a hexagon is regular or irregular based on the angles. If the interior angles are all congruent (120° each), then the hexagon is regular. If the interior angles don't meet this requirement, then the hexagon is irregular. Additionally, you can tell by the shape of the hexagon. If it is concave, it is irregular. If it is convex, it may or may not be regular, and you would have to check the angles.


### Area
The formula for the area of a regular hexagon with side length `s` is:

<code>A = (3√3*s<sup>2</sup>)/ 2</code>

For a hexagon with a side length of 4, the area would be calculated as:

<code> (3√3*<b>4</b><sup>2</sup>)/ 2 ≈ 41.57</code>

### Examples
A natural example of a hexagonal grid are bees' honeycombs.

<img src=https://upload.wikimedia.org/wikipedia/commons/3/3d/Honeycomb_15_03_2012.jpg alt="a honeycomb" height="200" /></br>

An unnatural example of a hexagonal grid is the New York County Supreme Court building on Foley Square, Manhattan:

<img src=http://www.secretsinplainsight.com/wp-content/uploads/NY-Supreme-Court.jpg alt="NYC Supreme Court Building" height="200" />


