---
title: Law of Sines
---
## Law of sines

The law of sines states that
```
sin(A)   sin(B)   sin(C)
------ = ------ = ------
  a         b        c
```
where A, B and C are angles, and a, b and c are their corresponding (opposite) side lengths. This law is used with triangles, when two angles and one side length are known. For example, consider the triangle
```
     b
____________
\        75/
 \        /
6 \      /
   \    /
    \30/
     \/
```
In this (isoceles) triangle, we know everything except for b, the angle opposite B = 30&deg;, therefore, we can use the law of sines to find it. With A = 75 and a = 6, we have
```
sin(A)   sin(B)      sin(75)   sin(30)
------ = ------ ===> ------- = -------
  a         b           6         b
```
Cross multiplying gives
```
    6 * sin(30)
b = -----------
      sin(75)
```
which simplifies to, approximately,

<p align='center'>
  b &approx; 3.106
</p>
