---
title: Linear Equations
---
## Linear Equations

A linear equation is an equation that can be written in the form

<p align='center'>a<sub>1</sub>x<sub>1</sub> + a<sub>2</sub>x<sub>2</sub> + &middot;&middot;&middot; + a<sub>n</sub>x<sub>n</sub> + b = 0,</p>

where the x<sub>i</sub> are the *variables* while b and the a<sub>i</sub> are the *coefficients*. The solutions to the equation, that is, the points (x<sub>1</sub>, x<sub>2</sub>, ..., x<sub>n</sub>) that make the equation true when plugged in, describe a graph (a [hyperplane](https://en.wikipedia.org/wiki/Hyperplane)) in n-dimensional space.

The most familiar example is in two dimensions, the Cartesian plane, where a linear equation describes a straight line. Here a linear equation is usually written as

<p align='center'>y = mx + b,</p>

where
* x and y are the coordinates,
* m is the *slope*, commonly called *rise over run* which describes the ratio between the vertical change and the horizontal change as you move along the line, and
* b is the *y-intercept*, where the line described by the equation touches the y-axis. (Plugging x=0 into equation shows this.)

Every non-vertical line can be described by such an equation. (While a vertical line can be described by the equation x = a for some number a, you no longer have the geometric interpretation from the values of m and b.) For example, suppose we wish to draw the line connecting the two points (1,3) and (-2,2). Then, between these two points the rise is the difference in the y-values, namely 3 - 2 = 1, while the run is the difference in the x-values, 1 - (-2) = 3, so the slope is m = 1/3. (Or 2 - 3 = -1 and -2 - 1 = -3, so m = (-1)/(-3) = 1/3.) This means our line is given by the equation

<p align='center'>y = (1/3)x + b,</p>

where b is the y-intercept. To find b we now plug either point into the equation and solve for b. For example, we can use (1,3) to get 3 = (1/3) &middot; 1 + b, or b = 3 - (1/3) = 8/3. Hence, the line going through the points (1,3) and (-2,2) is given by the equation

<p align='center'>y = (1/3)x + 8/3.</p>

While these may not appear terribly useful outside of simply working with lines (or hyperplanes in general), there are [many situations](https://en.wikipedia.org/wiki/Linear_approximation#Applications) where you can get a linear approximation of a complicated function and get valuable information. With the simplicity of linear equations, this can be a very powerful tool to study complex problems.
