---
title: Mean Median Mode and Range
---
## Mean, Median, Mode, and Range

Statisticians and mathematicians use the mean, median, mode, and range to learn information about a group of numbers. 

```
Example set:

5, -4, 11, 5, 5, 20, 8.5, 11
```

To calculate the **range** of a set, take the highest number, denoted x, and the lowest number, denoted y, and calculate x-y. Range will give an indication of how spread out the numbers are.
```
Smallest value: -4
Largest value: 20

20 - (-4) = 24

The range is 24
```  

To calculate the **mean**, add all the numbers together and divide by the total amount of elements in a group. This is what is normally meant when discussing the 'average'.
```
5 + (-4) + 11 + 5 + 5 + 20 + 8.5 + 11 = 61.5

Sum: 61.5
Count: 8

61.5 / 8 = 7.6875

The mean is 7.6875
```

To calculate the **mode**, look for the number that is repated the most frequently. For example, for the numbers 1,2,3,4,5,6,7,7,7 the mode would be 7 because there are three 7s in the group, which is higher than the amount of any other number.
```
Put the set in order so it's easier to see how
many of each value there are:

-4, 5, 5, 5, 8.5, 11, 11, 20

5 appears three times, 11 appears twice and
everything else appears once.

The mode is 5
```

To calculate the **median**, arrange all the numbers in increasing order and cross off the highest and lowest number until there is only one or two numbers left. If there is one number left, then that number is the median. If there are two numbers, then add the two numbers and divide by 2 to get the median. For example, in 1,2,3,4,5,6,7,7,7 the median would be 5.
```
First, put the set in order:

-4, 5, 5, 5, 8.5, 11, 11, 20

The third 5 and 8.5 are the middle values...
(5 + 8.5) / 2 = 6.75

The median is 6.75
```



