---
title: Pythagorean Theorem
---
## Pythagorean Theorem

The Pythagorean Theorem relates the three sides of a right triangle. A right triangle is a triangle in which one of the angles is a right angle (a 90-degree angle). The side of the triangle that is opposite to the right angle is called hypotenuse. Any of the other two side can be named 'base'(b) and the 'perpendicular/height(a)'. The angle opposite to the base(b) is denoted by 'B' and the one opposite to perpendicular'A'. By this the angle C is 90 degrees and is known as a right triangle.

A right triangle can only be isosceles or scalar. Never equilateral.

Let c be the length of the hypotenuse, a and b the length of the other sides.

The theorem states:

c<sup>2</sup> = a<sup>2</sup> + b<sup>2</sup>

c = &radic;(a<sup>2</sup> + b <sup>2</sup>), where c > 0

Whenever you are given two sides of a right triangle, you can calculate the third one using the Pythagorean Theorem.

In some instances, the value of the perpendicular height or the base may not be given, but the value of the hypotenuse can be given. So in this case: 

Let c become the length of the hypotenuse, a become the length of the perpendicular, and b become the length of the height. The Pythagoras Theorem is given by:

a<sup>2</sup> + b<sup>2</sup> = c<sup>2</sup>

The first case will be finding the unknown value of the perpendicular height, which is 'a'. So firstly, we will make a<sup>2</sup> become the subject:

a<sup>2</sup> = c<sup>2</sup> - b<sup>2</sup>

And then, we will square root both sides to get the value of a:

a = &radic;(c<sup>2</sup> - b<sup>2</sup>)

For the second case, we will be finding the unknown value of the base, which is 'b'. So we will firstly make b<sup>2</sup> become the subject:

b<sup>2</sup> = c<sup>2</sup> - a<sup>2</sup>

And then, we will square root both sides to get the value of b:

b = &radic;(c<sup>2</sup> - a<sup>2</sup>)

#### More Information:

- <a href = "https://www.khanacademy.org/math/basic-geo/basic-geometry-pythagorean-theorem">Khan Academy Pythagorean Theorem</a>
- <a href = "https://en.wikipedia.org/wiki/Pythagorean_theorem">Wikipedia Pythagorean Theorem</a>
