---
title: Quadratic Equations
---
## Quadratic Equations

_A quadratic equation_ is a polynomial function of degree 2, equated to 0 or a constant.

The parent equation for a quadratic function is **ax^2+bx+c=0** where x is variable and a, b and c are real constants.

* 'a' determines how wide or narrow the function is.
  * If |a| is greater than 1, the parabola will be narrow.
  * If |a| is less than 1, the parabola will be wider.

*  Roots of any function are the values of the parameter(s) where the function equates to zero. Roots of a quadratic equation (function actually) are the value of variable (here it is 'x' since the equation we have taken is quadratic in 'x') which satisfies the equation for a given set of constants (here--> a,b,c).
  
*  Every quadratic equations **ax^2+bx+c=0** can be expressed as **(x-p)(x-q)=0** where p and q will be the roots of the given quadratic equation. These roots may or may not be real in nature.

*  Quadratic functions create a parabola, also known as a 'u' shape.
  
*  The vertex of a quadratic funtion is the turning point of which the graph reflects itself (hence the vertex also relating to 'axis of symmetry', the line in which a quadratic function reflects).

*  The values of x where the graph of **y=ax^2+bx+c** touches the x axis are the roots of the quadratic equation **ax^2+bx+c=0**.

## ROOTS

A quadratic always have 2 roots. In case the quadratic function represents a perfect square, it is said that both the roots have the same value (saying that there is only one root will be wrong since a quadratic equation has to have 2 roots). The nature and value of roots can be calculated using the set of constants associated with it.

### Nature of Roots

As stated earlier, the roots of a quadratic equation are not always real. The nature of the roots can be determined easily by calculating the value of D which is given by b^2-4ac

**D=b^2-4ac**

*  If D>0, both the roots will be real in nature.
*  If D==0, both the roots will be real and equal in nature.
*  If D<0, both the roots will be imaginary in nature (no real value of x will satisfy the equation)

It can be easily observed that that the values of the roots are equal only when D==0 but the nature of roots is always the same for both roots.

### Value of Roots

Let the roots of **ax^2+bx+c=0** be p and q, then

p= (-b + sqrt(D))/2a

q= (-b - sqrt(D))/2a

* The the equation has imaginary roots, they will always be found in conjugate pairs. For example, if you know that one of roots is 2+3i then you can directly determine the other root as 2-3i by just changing the sign in between the real and imaginary part of value. (This can be inferred from the formula of calculating roots' value.)
