---
title: Rational Numbers
---
## Rational Numbers

A rational number is a real number that can be written as a fraction of two integers.

10/5 is a fraction, and is equal to 2. 8/3 is a fraction, and is equal to 2.66666.... Since the denominator of a fraction can be 1, every integer is a rational number. Note that as 2/1 = 4/2 = 6/3 = ..., each rational number can be represented by different fractions, but every rational number has a unique representation as an [*irreducible* fraction](https://en.wikipedia.org/wiki/Irreducible_fraction).

The decimal representation of a rational number either terminates or is infinite with a pattern that repeats, e.g., 1/2 = 0.5 or 1/3 = 0.333.... Note that the decimal representation -- similar to a fractional representation -- is not necessarily unique, e.g., 0.999... = 1.

Not all real numbers are rational. A real number that is not rational is called *irrational*, such as [sqrt(2)](https://en.wikipedia.org/wiki/Square_root_of_2), [pi](https://en.wikipedia.org/wiki/Pi) and [e](https://en.wikipedia.org/wiki/E_(mathematical_constant)). While it is easy to see a real number is rational (either express it as a fraction of integers or compute the decimal representation until it repeats) it is usually a lot more difficult to show a number is not rational.

The rational numbers have many nice properties. For example,
1. Addition of any two rational numbers `a/b`, `c/d` gives another rational number `(ad + bc)/(bd)`;
2. Multiplication of any two rational numbers `a/b`, `c/d`  gives another rational number `(ac)/(bd)`;
3. Any rational number `q` has an [additive inverse](https://en.wikipedia.org/wiki/Additive_inverse), `-q`;
4. Any non-zero rational number `q` has a [multiplicative inverse](https://en.wikipedia.org/wiki/Multiplicative_inverse), `1/q`;
5. Between any two distinct rational numbers there exists another rational number (e.g., the [mean](https://en.wikipedia.org/wiki/Arithmetic_mean) of the two rationals). 
6. Between any two distinct rational numbers there exists an irrational number (e.g., for almost any pair of rationals, the square root of their product is irrational).
7. Between any two distinct irrational numbers there exists a rational number (e.g., look at the decimal representations of both irrational numbers and pick a finite decimal between them).
8. There are ''[as many](https://en.wikipedia.org/wiki/Cardinality)'' rational numbers as there are positive integers!

Properties 1-4 give way to the rational numbers being a particularly nice mathematical structure called a [field](https://en.wikipedia.org/wiki/Field_(mathematics)). Properties 5-7 show that the rationals are a [dense](https://en.wikipedia.org/wiki/Dense_set) subset of the real numbers, making them quite useful for studying the set of all real numbers. Property 8 states the rational numbers are [countable](https://en.wikipedia.org/wiki/Countable_set).

The study of algebraic structures over the rational numbers instead of the real numbers is a very rich area of investigation including [Arithmetic Geometry](https://en.wikipedia.org/wiki/Glossary_of_arithmetic_and_diophantine_geometry), [Arithmetic Dynamics](https://en.wikipedia.org/wiki/Arithmetic_dynamics), [Cryptography](https://en.wikipedia.org/wiki/Cryptography), [Galois Theory](https://en.wikipedia.org/wiki/Galois_theory), [Number Theory](https://en.wikipedia.org/wiki/Number_theory), and more. There are also multiple [$1 million](http://www.claymath.org/millennium-problems) prizes for solving some of the deeper and most challenging problems involving the rational, so while they are well understood, there is still quite a lot unknown.
