---
title: Rules of Significant Figures
---
## Rules of Significant Figures

Significant figures of a number are all of the digits that carry meaning to the final representation of a measurement. They represent how precise the measurement is.

The rules to find which digits of a number are significant figures:
- All non-zero digits are significant
- All zeros between non-sero digits are significant: 202, 2002, 20002
- Leading zeros aren't significant
- In a decimal number, all trailing zeros represent precision, and thusly are significant
- In a non-decimal number, if there is a "." at the end, all figures to the left are significant (except leading zeros)

#### Examples:
* 0.05400 has [4] sig figs: 5, 4, 0 and 0
* 0.0054090 has [5] sig figs: 5, 4, 0, 9, and 0
* 100 has [1] sig fig: 1
* 100.0 has [3] sig figs: 1, 0, and 0
* More Information:

### More Information
* [wikipedia article](https://en.wikipedia.org/wiki/Significant_figures)
* [Khan Academy's video on sig figs](https://www.khanacademy.org/math/arithmetic-home/arith-review-decimals/arithmetic-significant-figures-tutorial/v/significant-figures)
* [Purplemath guide to sig figs](https://www.purplemath.com/modules/rounding2.htm)
* [nifty little sig fig calculator](https://www.omnicalculator.com/math/sig-fig)

