---
title: Scientific Notation
---
## Scientific Notation

Scientific notation is a way of writing very large/small numbers in order to more easily handle them in computation.

We can think of a number in scientific notation being comprised of a "digit term" and an "exponential term"

The digit term contains the significant figures of the number. The digit term must be a number between 1 and 10. The exponential term contains the placeholder zeros and locates where the decimal is placed. If the exponential term has a negative exponent, that means that the number is smaller than one, and that the decimal point must be moved a certain number of spaces to the left. Whereas a positive exponential number means that the number is very large and the decimal point must be moved to the right.

#### Example:
545,000,000,000 written in scientific notation: 5.45 x 10^11

0.0000000000030435 = 3.0435 x 10^-12

10 = 1.0 x 10^1

1 = 1.0 x 10^0

#### More Information:
* [Great article including arithmetic in scientific notation](https://www.chem.tamu.edu/class/fyp/mathrev/mr-scnot.html)
* [wikipedia article](https://en.wikipedia.org/wiki/Scientific_notation)

