---
title: Simplifying Square Roots
---
## Simplifying Square Roots

Let's say you have the radical &radic;363, and you need to simplify it into a both, simplest number, and a number that you can use in specific calculations, where we can do this by trying to find perfect squares within the radical.

So, it's a fact that: 

&radic;(x&times;y) = &radic;x &times; &radic;y

and this fact allows us to understand that we can seperate the &radic;xy into two separate radicals, &radic;x and &radic;y.

But first, we need to find a factor of 363, that would allow us to pull a perfect square from it.
Perfect square numbers include: 1, 4, 9, 16, 25, 36, 49, 64, 81, 100, 121, 144 etc. ,as each of them can become a whole number if these numbers were square rooted.

Now, factors of 363 are: 1, 3, 11, 33, 121 and 363. 

If you look, you can see that 121 is among that list, 121&times;3 is 363, and we can change the radical to show that:

&radic;363 = &radic;(121&times;3) = &radic;121 &times; &radic;3 

And we can take the square root of 121, where we can turn it into a whole number: 

= 11 &times; &radic;3 

Hence, 11&radic;3 is the square root number of 363. 

## Simplifying Square roots in the Denominator:
Lets' say you have the expression: 

<sup>2</sup>&frasl;<sub>&radic;5</sub>

And you wanted to simplify this by removing the radical from the denominator, well you can do this by multiplying this fraction by: 

<sup>&radic;5</sup>&frasl;<sub>&radic;5</sub> 

Which is equal to one, and you get:

<sup>2</sup>&frasl;<sub>&radic;5</sub> &times; <sup>&radic;5</sup>&frasl;<sub>&radic;5</sub> 

= <sup>2&radic;5</sup>&frasl;<sub>5</sub>  

because a square root multiplied by itself is the number in the square, the denominator is now a whole number, not a radical anymore. The radical still exists in the top, but this is fine in most cases, as the value itself is still exact.

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
