---
title: The Distance Formula
---
## The Distance Formula
<a href="https://www.codecogs.com/eqnedit.php?latex=\mathrm{Distance}=\sqrt{(x_{2}&plus;x_{1})^2&space;&plus;&space;(y_{2}&space;&plus;&space;y_{1})^2}" target="_blank"><img src="https://latex.codecogs.com/gif.latex?\mathrm{Distance}=\sqrt{(x_{2}&plus;x_{1})^2&space;&plus;&space;(y_{2}&space;&plus;&space;y_{1})^2}" title="\mathrm{Distance}=\sqrt{(x_{2}+x_{1})^2 + (y_{2} + y_{1})^2}" /></a>

In analytic geometry, the distance between two points of the [xy-plane](https://en.wikipedia.org/wiki/Cartesian_coordinate_system) can be found using the distance formula.  The distance between (*x*<sub>1</sub>, *y*<sub>1</sub>) and (*x*<sub>2</sub>, *y*<sub>2</sub>) is given by:

<img src="https://latex.codecogs.com/gif.latex?d=\sqrt{(\Delta&space;x)^2&plus;(\Delta&space;y)^2}=\sqrt{(x_2-x_1)^2&plus;(y_2-y_1)^2}." title="d=\sqrt{(\Delta x)^2+(\Delta y)^2}=\sqrt{(x_2-x_1)^2+(y_2-y_1)^2}." />

This formula is easily derived by constructing a right triangle with a leg on the hypotenuse of another (with the other leg orthogonal to the plane that contains the 1st triangle) and applying the Pythagorean theorem.
In the study of complicated geometries, we call this (most common) type of distance [Euclidean distance](https://en.wikipedia.org/wiki/Euclidean_distance), as it is derived from the [Pythagorean theorem](https://en.wikipedia.org/wiki/Pythagorean_theorem), which does not hold in non-Euclidean geometries. This distance formula can also be expanded into the arc-length formula.

#### Distance in Euclidean space
In the [Euclidean space](https://en.wikipedia.org/wiki/Euclidean_space) **R**<sup>n</sup>, the distance between two points is usually given by the Euclidean distance (2-norm distance).  Other distances, based on other norms, are sometimes used instead.

The 2-norm distance is the Euclidean distance, a generalization of the Pythagorean theorem to more than two coordinates. It is what would be obtained if the distance between two points were measured with a ruler: the "intuitive" idea of distance.

The 1-norm distance is more colourfully called the *taxicab norm* or taxicab geometry ([Manhattan distance](https://en.wikipedia.org/wiki/Taxicab_geometry)), because it is the distance a car would drive in a city laid out in square blocks (if there are no one-way streets).

The infinity norm distance is also called [Chebyshev distance](https://en.wikipedia.org/wiki/Chebyshev_distance). In 2D, it is the minimum number of moves kings require to travel between two squares on a chessboard.

The *p*-norm is rarely used for values of *p* other than 1, 2, and infinity, but see [super ellipse](https://en.wikipedia.org/wiki/Super_ellipse).

In physical space the Euclidean distance is in a way the most natural one, because in this case the length of a rigid body does not change with rotation.

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
[Wikipedia: Distance](https://en.wikipedia.org/wiki/Distance)
