---
title: Trigonometric Identities
---
# Trigonometric Identities

*Trigonometric Identities* are equalities that involve trigonometric functions. Trigonometric functions are functions of an angle that relate the angles of a triangle to the lengths of its sides (e.g. sine, cosine, and tangent). *Trigonometric Identities* are true for every value of the variables where both sides of the equality are defined.

Whenever expressions involving trigonometric functions need to be simplified, *Trigonometric Identities* are very useful.

## List of Trigonometric Identities

- Angle Addition Formulas
- Double-Angle Formulas
- Half-Angle Formulas
- Harmonic Addition Theorem
- Mollweide's Formulas
- Morrie's Law
- Multiple-Angle Formulas
- Newton's Formulas
- Prosthaphaeresis Formulas
- Simpson's Formulas
- Sine-Tangent Theorem
- Trigonometric Addition Formulas
- Trigonometric Power Formulas
- Trigonometric Series Formulas
- Trigonometry Angles
- Trigonometry Angles--0
- Trigonometry Angles--Pi/2 - Pi/32
- Wallis Cosine Formula
- Wallis Formula
- Wallis Sine Formula
- Weierstrass Substitution
- Werner Formulas

#### Cosines and Sines Around the Unit Circle

![Cosine and Sine are the Unit Circle](https://upload.wikimedia.org/wikipedia/commons/thumb/4/4c/Unit_circle_angles_color.svg/640px-Unit_circle_angles_color.svg.png?1507763902323)

## Other Resources

- <a href='http://mathworld.wolfram.com/topics/TrigonometricIdentities.html' target='_blank' rel='nofollow'>Wolfram MathWorld - Trigonometric Identities</a>
- <a href='http://mathworld.wolfram.com/TrigonometryAnglesPi3.html' target='_blank' rel='nofollow'>Wolfram MathWorld - Trigonometry Angles--Pi/3</a>
- <a href='http://mathworld.wolfram.com/30-60-90Triangle.html' target='_blank' rel='nofollow'>Wolfram MathWorld - 30-60-90 Triangle</a>
- <a href='https://www.wikiwand.com/en/List_of_trigonometric_identities' target='_blank' rel='nofollow'>Wikipedia - List of Trigonometric Identities</a>
- <a href='https://www.wikiwand.com/en/Trigonometric_functions' target='_blank' rel='nofollow'>Wikipedia - Trigonometric Functions</a>
