---
title: Dot Product
---

# Dot Product

The dot product of vectors is also know as the “scalar” product.

#### Formula
If <span class="texhtml"><strong>a</strong></span> and <span class="texhtml"><strong>b</strong></span> are two vectors meeting at a point, whose moduli are |<span class="texhtml"><strong>a</strong></span>| and |<span class="texhtml"><strong>b</strong></span>| respectively and <span class="texhtml"><strong>θ</strong></span> is the angle between them, then the “dot” or “scalar” product of the two vectors is given as:

<span class="texhtml"><strong>a.b</strong></span> = <span class="texhtml">|<strong>a</strong>|</span><span class="texhtml">|<strong>b</strong>|</span> cosθ

Also, if the two vectors (<span class="texhtml"><strong>a</strong></span> and <span class="texhtml"><strong>b</strong></span>) are given in terms of their [unit vectors](https://en.wikipedia.org/wiki/Unit_vector), where
 
<span class="texhtml"><strong>a</strong></span> =  x<sub>1</sub>i + y<sub>1</sub>j

and  

<span class="texhtml"><strong>b</strong></span> =  x<sub>2</sub>i + y<sub>2</sub>j

Their dot product is given as:

<span class="texhtml"><strong>a.b</strong></span> = (x<sub>1</sub>i + y<sub>1</sub>j) * (x<sub>2</sub>i + y<sub>2</sub>j)

Since <span class="texhtml"><em>i</em></span> and <span class="texhtml"><em>j</em></span> are [unit vectors](https://en.wikipedia.org/wiki/Unit_vector) (equivalent to one), then

<span class="texhtml"><strong>a.b</strong></span> = (x<sub>1</sub> * x<sub>2</sub>) + (y<sub>1</sub> * y<sub>2</sub>)

### More Information:

1. [Euclidean vector](https://en.wikipedia.org/wiki/Euclidean_vector)
2. [Vector and Vector Arithmetic](http://spiff.rit.edu/classes/phys311.old/lectures/vector/vector.html)
