---
title: Introduction to Vectors
---

# Introduction to Vectors.

A vector is a physical quantity that can be measured (has magnitude in units) and also operates in a particular direction, unlike a scalar which can only be measured. Examples of vectors include velocity, acceleration, force and momentum.

A vector can be represented by a line drawn, such that:
- the length of the line represents the <span class="texhtml"><em><strong>magnitude</strong></em></span> of the vetor in a given unit;
- the direction of the line represents the <span class="texhtml"><em><strong>direction</strong></em></span> in which the vector operates (or acts).

![vector-representation](https://github.com/xeroxism/myImages/blob/master/FCC_guides/vector-representation.png?raw=true)

In the figure above, the displacement of A to B is written as <span class="texhtml"><strong> AB</strong></span> (<span class="texhtml"><strong>ā</strong></span> or <span class="texhtml"><strong>a</strong></span>). point A is the origin or initial point and the point B is the head or terminal point. This displacement is equivalent to moving a distance <span class="texhtml"><em>x</em></span> horizontally followed by<span class="texhtml"><em> y</em></span> vertically.

### The Modulus of a vector
The modulus of a vector is a positive scalar number that gives magnitude of the vector. It is written like this:

<pre> <span class="texhtml">|<strong>AB</strong>|</span> or <span class="texhtml">|<strong>a</strong>|</span> or simply <span class="texhtml"><strong>AB</strong></span> or <span class="texhtml"><strong>a</strong></span>. </pre>

Where;
<pre>|AB| =  <span class="texhtml"> √(<i>x</i><sup>2</sup> + <i>y</i><sup>2</sup>)</span></pre>

### More Information:

1. [Euclidean vector](https://en.wikipedia.org/wiki/Euclidean_vector).
2. [Vector and Vector Arithmetic](http://spiff.rit.edu/classes/phys311.old/lectures/vector/vector.html).


