---
title: Free Code Camp Issue Labels
---
In this article you can find labels (see the table below) used to categorize the variety of issues submitted to FCC, along with descriptions (work in progress). The labels range from **bugs** to **questions** to **curriculum requests**.

You can use labels to help you choose which issues to click on, rather than randomly clicking to find one of interest to you. Of course, you can work on and submit PRs for issues without labels. However you choose an issue, please be sure to read the <a href='https://github.com/FreeCodeCamp/FreeCodeCamp/blob/staging/CONTRIBUTING.md' target='_blank' rel='nofollow'>Guidelines for Contributing</a> before submitting any pull requests.

Note: The labels **_blocked_**, **_confirmed_**, and **_QA_** are also tied to <a href='https://waffle.io/freecodecamp/freecodecamp' target='_blank' rel='nofollow'>Waffle</a>, a management system for FCC (GitHub) issues, and are automatically added and removed by it.

**Label:** Description

**accessibility:** The issue doesn't necessarily break the site, but it makes it harder to use (for example, tests used to evaluate while you typed, which would cause the whole screen to flicker). This label also marks improvements to the site's usability for people with vision impairment or other disabilities.

**accounts:** A camper has a problem with his/her FCC account, such as login problems, losing progress, or a profile page that is missing some solutions.

**beta:** The issue is related to FCC's beta site.

**bike shedding:** The request is are trivial or essentially irrelevant to the purposes of the site. In other words, issues that have no real consequence, yet which people insist on spending cycles on.

**blocked:** An issue that should not be worked on, while awaiting the creator's response or more information, or because the issue is stale.

**bug:** A confirmed and reproducible bug in FCC's code that occurs not only, for example, in Internet Explorer.

**chrome:** The issue can be reproduced only in Google Chrome.

**confirmed:** The reported issue has been verified. (It basically says the issue creator has successfully communicated how to replicate the issue, but no one has started working toward a fix.)

**curriculum request:** Anything that is requested to be added to current curriculum—for example, requesting a new challenge, adding more explanation to a challenge, etc.

**device specific:** The issue presents only for a particular device (smartphone, tablet, desktop, etc.).

**Discussing:** This issue is currently at the discussion stage.

**duplicate:** This issue duplicates another issue and most likely will be closed.

**first-timers-only:** This issue is not critical but should be easy for a camper to fix within their first couple of PRs. Think of these as the camper's gateway to becoming a contributor.

**enhancement:** Similar to a Feature Request, but more related to improving existing features rather than adding new ones.

**feature request:** A request to add a feature to FCC. For example, a request to add the ability to edit or remove Algorithms from a camper's profile page.

**firefox:** The issue can be reproduced only in Mozilla Firefox.

**help wanted:** Owners or issue moderators need campers' help to investigate or fix the issue.

**hikes:** The issue is related to Hikes (which are not currently available in the curriculum).

**ie/edge:** The issue can be reproduced only in Internet Explorer or Microsoft Edge. FCC officially supports only Google Chrome.

**in progress:** Someone is currently making a fix for the issue.

**must start ASAP:** This issue needs to be reviewed/resolved as soon as possible.

**on the roadmap:** Generally, a feature request that is planned to be implemented in future updates or that will be implemented in the near future.

**QA:** (Quality Assurance) A fix has been submitted and needs to be reviewed before merging.

**question:** The issue is a question.

**reactify:** The issue is related to moving to reactjs.

**resolved:** The issue is resolved/fixed.

**tests:** The issue should be fixed with a test improvement, meaning someone needs to fix asserts.

**todo:** Something that needs to be done in future.

**translation:** The issue is either a translation request or related to an already implemented translation.

**ux:** (User Experience) Similar to accessibility, but less about whether something is difficult to use than it is about campers' experiencing an issue that leads to a negative user experience. For example, this tag is used when something may be too complicated or when the use of a feature is difficult to understand.

**wiki:** Relates to FCC's GitHub Wiki articles. May be a request to create one.

**wontfix:** The issue is not fixable or will not be fixed in near future. For example, adding support for the MS Edge browser.