---
title: Agile Project Management Terminology
---
During the Free Code Camp volunteer projects we use an Agile Project Management methodology. For many of our campers and stakeholders, this is their first exposure to Agile. While you're not expected to be an Agile expert, here are a few terms it would be helpful to know:

*   **Task Board** - A chart that lists what needs to be done, what's being worked on, and what's been completed. We use Trello as our task board.
*   **Sprint** - A period of development. We generally use a one week sprint length.
*   **Sprint Conference** - A meeting held at the end of each sprint to discuss the progress made and solicit feedback. Also commonly referred to as a sprint review.
*   **Stakeholder** - Someone outside the development team who has an interest in the project and its development.
*   **User Story** - A requirement or feature that the product must meet/include.

For additional information on Agile you can check out the <a href='https://en.wikipedia.org/wiki/Agile_management' target='_blank' rel='nofollow'>agile management</a> page on Wikipedia or take a look at the <a href='http://www.dummies.com/how-to/content/agile-project-management-for-dummies-cheat-sheet.html' target='_blank' rel='nofollow'>Agile Project Management for Dummies Cheat Sheet</a>.

## Tools we use

<a href='http://www.gotomeeting.com' target='_blank' rel='nofollow'>GoToMeeting</a> - We use GoToMeeting to hold our online project management conferences.

<a href='http://www.when2meet.com' target='_blank' rel='nofollow'>When2Meet</a> - We use When2Meet to share our availability with the team.

<a href='http://www.trello.com' target='_blank' rel='nofollow'>Trello</a> - We use Trello to track our volunteer web development projects.

<a href='https://www.google.com/calendar' target='_blank' rel='nofollow'>Google Calendar</a> - We use Google Calendar to track our project conferences.

## Trello Board Standard Layout

When setting up the Trello board for your project, create the following lists (in this order left to right).

*   **General Information** - This list will include general information that might be useful to the team such as links to current sites, a description of the current or proposed workflow, or any other information that could be useful to the development team.
*   **Project Scope** - This list provides a general outline of what the project should accomplish.
*   **User Stories** - These are the _specific_ features that the development must include.
*   **In Progress** - These are the user stories that the team is currently working on.
*   **Recently Completed** - These are the user stories that the team has completed since the last project conference.
*   **Demo'd** - These are the user stories that have been demo'd to, and accepted by, the client.

## Organizing a Scope Call

In Progress.

## Sprint Call Checklist

### 1-2 Days Prior to the Conference

*   Check the Google Calendar event and reach out to any individuals that have not responded.

### The Day of, and during, the Conference

1.  Send out conference invite and details 10 minutes before the call is scheduled.
2.  Join the meeting at least 5 minutes early. You should be unmuted and available to engage in conversation with the campers and stakeholder(s).
3.  Show and Tell time. Ask the campers "So what did you work on this week? Would you like to share your screen and demo?"
4.  Ask the campers "Did you run into any issues this week?"
5.  Go through each card in the Recently Completed list and make sure that the user story has been addressed.
6.  Ask the stakeholder if they have any questions about the Recently Completed user stories.
7.  After each Recently Completed card has been discussed, drag it over to the Demo'd list.
8.  Ask the campers "What are you planning to work on this week?"
9.  Drag the chosen User Stories card to the In Progress list.
10.  Schedule the next sprint conference. "Same time next week?" usually works well. Don't forget to send out invites using Google Calendar.