---
title: Creating a New GitHub Issue
---
Before submitting an issue try <a href='https://forum.freecodecamp.com/t/searching-for-existing-issues-in-github/18390' target='_blank' rel='nofollow'>Searching for Your Issue on GitHub</a>

Crafting a good issue will make it much easier for the dev team to replicate and resolve your problem. Follow these steps to do it right:

1.  Go to FreeCodeCamp's <a href='https://github.com/FreeCodeCamp/FreeCodeCamp/issues' target='_blank' rel='nofollow'>GitHub Issues</a> page and click on `New Issue`.
2.  **Have a useful title**
    *   Write a meaningful title that describes the issue. Some good examples are `Logging in from the News and Field Guide pages doesn't redirect properly (using e-mail)` and `Typo: "for" instead of "while" loop`; bad examples include `A bug, HELP!!!11` and `I found this bug in a Challenge`.

    *   Keep the title relatively short, the description is for further information. One example is to shorten long Challenge names, so instead of writing `Test case bug in 'Challenge: Check Radio Buttons and Checkboxes by Default'`, you might want to write `Test case bug in 'Radio Buttons' Challenge`.
3.  In the body, **provide a link** to the page on which you encountered this issue.

4.  **Describe the problem** and **provide steps** so that a developer can try to replicate the issue. Include your operating system and browser version.

    *   When referencing other issues or pull requests, simply write <span class="hashtag">#issue</span>/pr-number.

5.  Paste in any relevant code using proper <a href='https://forum.freecodecamp.com/t/markdown-code-formatting/18391' target='_blank' rel='nofollow'>Code Formatting</a>

6.  **Take a screenshot** of the issue and include it in the post.

7.  Click `Submit New Issue` and you are done! You will be automatically subscribed to notifications for any updates or future comments.
