---
title: Design Resources for Front End Developers
---
Are you a freelance front-end web developer or are you thinking about becoming one? Maybe you've been to a coding bootcamp or graduated from an online front-end development course. What happens next?

You get your first customer. It might just be a friend who needs a personal website. It doesn't matter. You don't want it to look amateurish. You want it to look good. You want it to look professional.

Here's the thing...

Good design can mean the difference between a website that looks "homemade" and one that looks professional. If you're going to make money at freelance web development you can't afford to be making sites that don't showcase good design principles. Most people(ie potential clients) know what good design looks like even if they can't tell you why it's good design. Therefore, it pays to have an understanding of basic design concepts. In fact, I would go so far as to say that it's absolutely necessary if you're going to have a successful career as a freelance front-end developer.

So, where do you start? Where do you go to learn about design? Fortunately, you don't need to pay money to learn the foundational basics of design. There are many resources out there that are 100% free. Here are 10 resources(most of them free) that that will help you be a better freelance front-end developer because they will help you be a better designer. Have fun!

## 1\. <a href='https://hackdesign.org' target='_blank' rel='nofollow'>Hackdesign.org</a>

Let's start with the basics. If you want to produce attractive, professional-looking, front-end work you absolutely need to learn the basics of design. Let me say that one more time. You need to learn the basics of design. Yeah, it's that important. Believe me. It's going to help you stand out from all the freelance front-end developers who aren't learning it and that means you'll get more work. More work means more money. See what I mean? It's important.

Go through Hackdesign's lessons from start to finish and let it all sink in. If you want you can sign up for weekly lessons sent to your email address. However, you don't need to do that. You can just click on "view all lessons" and start working your way through it. It's fairly in-depth. It's not something that you're going to do in a couple of hours. Spend some serious time here on this resource.

## 2\. <a href='http://designforhackers.com' target='_blank' rel='nofollow'>Design For Hackers</a>

David Kadavy's reason for writing the book is summed up nicely in this quote:

> "We can create flyers, postcards, and PowerPoint presentations complete with animations. We can create blogs, posters, and even coffee mugs...But few of us are design literate."

Same thing goes for the creation of websites. Just because you can create a website that works doesn't mean that you can create a beautiful, well designed website that works. It doesn't mean that you can create a website that looks professional. I'm sure you know what I mean. Good design looks professional. Period. So, read this book. Kadavy also has a website at ​ designforhackers.com where you can sign up for an email-based course called "Design Pitfalls".

## 3\. <a href='http://thehipperelement.com/post/75476711614/ux-crash-course-31-fundamentals' target='_blank' rel='nofollow'>UX Crash Course: 31 Fundamentals</a>

Remember, you're a freelancer and that means that you're wearing many hats. Just knowing how to code isn't going to cut it if you want to be a great freelancer that's in high demand.

This "crash course" by Joel Marsh is great for learning the basics of UX. He says, "The following list isn't everything you can learn in UX. It's a quick overview, so you can go from zero-to-hero as quickly as possible." What are you waiting for? Get started!

## 4\. <a href='http://thehipperelement.com/post/87574750438/ux-crash-course-user-psychology' target='_blank' rel='nofollow'>UX Crash Course: User Psychology</a>

Part two of Joel Marsh's terrific ​ UX Crash Course: 31 Fundamentals​ . He sums up why this is important:

> "...the more you understand your users' feelings, thoughts, and actions, the better designer you are."

You want to be both a great developer and a great designer, right? If you didn't you wouldn't have read this far. Well, how are you going to be a great, or even a good, designer if you're clueless about your users? You gotta think about those users. They matter because you are building websites that people are going to use. Be kind to them. Learn something about user psychology.

## 5\. <a href='https://www.materialpalette.com/' target='_blank' rel='nofollow'>Material Palette</a>

An attractive color palette alone can go a long way toward making a design look professional. So, if you've got through the basic design stuff I mentioned above but still aren't sure about how to apply color theory, bookmark this site now and start using it. Just click on two colors and like magic a beautiful, full color palette appears. Other good sites for color palettes are <a href='http://www.flatuicolors.com' target='_blank' rel='nofollow'>**flatuicolors**</a> and <a href='http://www.coolors.co' target='_blank' rel='nofollow'>**coolors**</a> .

## 6\. <a href='https://helpx.adobe.com/photoshop/tutorials.html' target='_blank' rel='nofollow'>Basics Of Adode Photoshop</a>

You're going to need to at least have a handle on the basics of Photoshop in order to work with photos and create web-ready graphics. Browse throgh these free Adobe Photoshop CC tutorials on Adobe's site. They are very well done, cover the basics, and will be enough to get you started!

## 7\. <a href='https://helpx.adobe.com/illustrator/tutorials.html' target='_blank' rel='nofollow'>Basics of Adobe Illustrator</a>

You may be thinking that since you're not a graphic artist there's no need to know how to use Adobe Illustrator. Wrong! Sure, maybe you're not going to create your own artwork from scratch. However, what if you want to use someone else's vector art? Let's say that you found a beautiful vector image on iStock that you want to use. However, the color is wrong or you would like to delete part of the image. No problem. Learn the basics of Illustrator and get the job done in no time!

## 8\. <a href='http://webtypography.net' target='_blank' rel='nofollow'>Elements Of Typographic Style Applied To The Web</a>

Typography may seem a bit boring but it's important. Even if you don't commit all of the information presented here to memory just knowing that in a perfect design world this stuff matters will help increase your awareness. Read a little bit at a time. I like this site because the information is presented in little, easily digestible tidbits. For example, check out this one minute read on <a href='http://webtypography.net/2.1.7' target='_blank' rel='nofollow'>**letterspacing**</a>

## 9\. <a href='http://www.amazon.com/Dont-Make-Me-Think-Usability/dp/0321344758' target='_blank' rel='nofollow'>_Don't Make Me Think_ by Steve Krug</a>

You are building sites that real people are going to use. You don't want your sites to complicate lives and frustrate people. You want your sites to make their life easier. Ok, well, you're going to need to know something about web usability and this is the classic book on web usability. Jeffrey Zeldman, founder of <a href='http://alistapart.com/' target='_blank' rel='nofollow'>**A List Apart**</a> magazine, says that "if you design, write, program, own, or manage Web sites, you must read this book." Well said. Read this book.

## 10\. <a href='http://www.amazon.com/Creativity-Challenge-Experiment-Innovate-Inspire/dp/1440588333' target='_blank' rel='nofollow'>_The Creativity Challenge_ by Tanner Christensen</a>

Finally, if you're a freelance web developer wearing a variety of hats you're going to have to keep your creativity in top shape and that means exercising it. This books contains 150 fun challenges aimed at getting you to think outside the box and see things from a different angle. The book's introduction sums it up nicely: "Whenever you feel stuck or uninspired, simply turn to a random page and follow the instructions to complete the creative challenge you find there."