---
title: Getting Started with Android Development
---
Today <a href='https://www.android.com/' target='_blank' rel='nofollow'>Android</a> has become the leading Operating System being used in various devices, like mobile phones, tablets, watches, TVs, cars and more. It powers more than a billion devices all over the globe. It is based on the Linux kernel. Android has been the best selling OS on tablets since 2013, and on smartphones it is dominant by any metric.


## Prerequisites

For getting started with Android development, you should already know about a few things:

*   <a href='https://java.com/en/' target='_blank' rel='nofollow'>Java</a>: Android development is mostly done in Java. It's not a difficult language to learn, but knowing how it applies to Android development can be confusing without a firm foundation in the language. Android Java is not exactly standard Java, but learning standard Java will make it much easier for you to pick up Android development. For the specific topics in Java that would be helpful in this case, you can refer to <a href='http://www.bigknol.com/2016/01/10-prerequisites-for-learning-android.html' target='_blank' rel='nofollow'>this link</a>.
*   <a href='http://www.w3schools.com/xml/' target='_blank' rel='nofollow'>XML</a>: Knowing XML can be useful in a number of tech-related fields and Android is no exception. In particular, XML files make it easier to declare UI elements in the apps you create. Past experience is a big plus.
*   Perseverance: Lastly, learning the ins and outs of the Android development toolkit is going to take time. Learning how to create a quality app is going to take even more time. Don't rush. Keep at it and focus your mind on the long term. If you don't, you'll be frustrated and want to give up.

## Tools

At first, make sure you have all the tools in your system. **Please note that the packages required to proceed with learning Android development require downloads of more than 1 GB and the installation could take about 2 to 3 hours of your time.** The things you'll need to start building applications for Android are:

*   <a href='http://www.oracle.com/technetwork/java/javase/downloads/index.html' target='_blank' rel='nofollow'>Latest version of the Java JDK</a>: <a href='https://github.com/FreeCodeCamp/FreeCodeCamp/wiki/Java-Introduction' target='_blank' rel='nofollow'>Here</a> is a guide to install Java on your computer.
*   <a href='http://developer.android.com/sdk/index.html' target='_blank' rel='nofollow'>Android Studio</a>: <a href='http://developer.android.com/sdk/installing/index.html' target='_blank' rel='nofollow'>Here</a> is the official guide to install Android studio.
*   If possible, an Android device. If you don't, it is fine too, since you can run an <a href='http://developer.android.com/tools/devices/emulator.html' target='_blank' rel='nofollow'>emulator</a> to run an Android virtual device on your computer.


## Kotlin language support
 Starting with Android Studio 3.0, tooling support for Kotlin is bundled directly into Android Studio. 
**Kotlin** is a statically-typed programming language that runs on the Java Virtual Machine and also can be compiled to JavaScript source code. Kotlin is designed to interoperate with Java code and is reliant on Java code from the existing Java Class Library, such as the collections framework.
**Kotlin** is designed to be an industrial-strength object-oriented language, and a "better language" than Java, but still be fully interoperable with Java code, allowing companies to make a gradual migration from Java to Kotlin.

Some of the benefits of Kotlin usage in Android Development:
* Kotlin requires less code to write.
* Less crashes occur on Kotlin.
* Kotlin is a type-safety language.
* Kotlin saves you some of your precious time.


## Tutorials

Some basic courses and tutorials for learning Android development:

*   <a href='http://developer.android.com/training/index.html' target='_blank' rel='nofollow'>Official Android Developer Guide</a>: For beginners, this site has a comprehensive training section that ranges from setting up your environment and building your first Android app all the way to distributing a finalized app and making money on the Play Store. For advanced users, the API guides and references will always be there to help you find the most efficient solutions to your app-development troubles. This guide also contains links to the specific video courses required by the developers' needs for advanced development topics.
*   <a href='https://guides.codepath.com/android' target='_blank' rel='nofollow'>CodePath Android Cliffnotes</a>
*   <a href='http://www.tutorialspoint.com/android/' target='_blank' rel='nofollow'>TutorialsPoint</a>
*   <a href='http://www.vogella.com/tutorials/android.html' target='_blank' rel='nofollow'>Vogella</a>

## Resources

Here are some useful links to the libraries for Android development:

*   <a href='https://github.com/wasabeef/awesome-android-ui' target='_blank' rel='nofollow'>Awesome Android UI</a> list by Wasabeef
*   <a href='https://github.com/snowdream/awesome-android' target='_blank' rel='nofollow'>Awesome Android Libraries</a> list by SnowDream
*   <a href='https://github.com/wasabeef/awesome-android-libraries' target='_blank' rel='nofollow'>Awesome Android Libraries</a> list by Wasabeef
