---
title: How to Contribute Via a Pull Request
---
> A pull request (PR) is a method of submitting contributions to an open source project. It is often the preferred way of submitting contributions to a project using a Distributed Version Control System (DVCS) such as Git.

FreeCodeCamp is an Open Source project and all of the contents are freely editable.

*   <a href='https://help.github.com/articles/fork-a-repo/' target='_blank' rel='nofollow'>Fork</a> the project on GitHub.
*   <a href='https://help.github.com/articles/cloning-a-repository/' target='_blank' rel='nofollow'>Clone</a> it to a local machine. Do not edit online in github.com, as the editor may cause issues with JSON formatted data.
*   <a href='https://help.github.com/articles/creating-and-deleting-branches-within-your-repository/' target='_blank' rel='nofollow'>Create a branch</a> with the form `fix/some-bug` or `feature/add-cool-thing` and make your changes in that branch and commit them.
*   <a href='https://help.github.com/articles/pushing-to-a-remote/' target='_blank' rel='nofollow'>Push</a> the branch online (if editing locally).
*   <a href='https://help.github.com/articles/creating-a-pull-request/' target='_blank' rel='nofollow'>Create a pull request</a> against the **"staging"** branch.
*   The title (also called the subject) of your PR should be descriptive of your changes. i.e. `fix typo in basic-javascript challenge`
*   If the PR is meant to fix a specific issue, append to the end of your PR's commit message `closes #1337`. This tells GitHub to close that issue if the PR is merged.
*   Do NOT add issue numbers to the PR's title. i.e. `minor improvements in basic-javascript challenge`

These are general guidelines for PR's that work across most projects. It gives everyone a quick guide to your changes when looking at the commit history of a project.

_Note: Not all pull requests are accepted. FCC project maintainers will explain the reason of non-acceptance._

## Further Reading

*   <a href='https://www.youtube.com/playlist?list=PLg7s6cbtAD15G8lNyoaYDuKZSKyJrgwB-' target='_blank' rel='nofollow'>GitHub & Git Foundations Training</a> - How to use Git and GitHub
*   <a href='https://github.com/FreeCodeCamp/FreeCodeCamp#contributing' target='_blank' rel='nofollow'>FreeCodeCamp Contribution Guidelines</a>
*   <a href='http://chris.beams.io/posts/git-commit/' target='_blank' rel='nofollow'>How to write Git commit messages</a>
*   <a href='https://forum.freecodecamp.com/t/how-to-clone-and-setup-the-free-code-camp-website-on-a-windows-pc/19366' target='_blank' rel='nofollow'>How to Clone FCC to a Windows PC</a>