---
title: How to Create a Local Study Group
---
If you didn't see your city on <a href='https://www.freecodecamp.com/study-group-directory/' target='_blank' rel='nofollow'>our list of study groups</a>, and you are willing to lead a study group for your city, follow the directions below.

This also applies to creating smaller, more cohesive groups for neighbourhoods and districts inside of the same city. Thus, groups should ideally represent areas where its members don't have to commute longer than 15-20 minutes to meet each other.  
However, be aware people may want to join from other places, as they may intend on moving there, or see your group as a nice source of resources and feedback, etc.

**Please, do not create groups for a whole state/province/department/county/etc. as they will not be added to the list.**

Assuming you've already signed into Facebook:  

(This part is optional) While creating the group you'll need to add at least one person. You could add <a href='https://www.facebook.com/FCC.GroupChancellor' target='_blank' rel='nofollow'>Justin</a> as a friend, who's in charge of freeCodeCamp's local groups and can **assist you in managing your members, events, and any issues that may come up (such as spammers, etc.)**.  
Also, he will probably not see be able to see any messages you may send until you "friend" him.

Now, to the fun part! It's easy, just follow these steps:

1.  Click the down arrow in the upper right corner of the screen, then choose "Create Group" from the options.

![A screenshot of Facebook showing the drop down menu that appears when you click the down arrow, with an arrow pointing to the "Create Group" option](//discourse-user-assets.s3.amazonaws.com/original/2X/9/9b58a494046871476342efb4b2e8d09426f7f9e3.png)  

2 . Set the group name as "freeCodeCamp" + the name of your city.

*   Avoid using slang terms such as "Philly" for "Philadelphia".
*   If your city is not the biggest city that uses its name, also include the state or province. For example, the freeCodeCamp group in Paris, France should be called "freeCodeCamp Paris". The freeCodeCamp group in Paris, Texas should be called "freeCodeCamp Paris, TX".
*   If you are in North America, we suggest you add the initials of your state/province here.

3 . Set your group to public.

![A screenshot of the Facebook group creation modal saying that your group name should be freeCodeCamp plus your city name, that your group should be public, and that you need to invite at least one Facebook friend.](//discourse-user-assets.s3.amazonaws.com/original/3X/e/4/e49fe1e0a5b675c80dc4313252a5f92fd866472c.png)  

4 . Choose the graduation cap icon to indicate that this group is related to education.

![A screenshot telling you to choose the graduation icon, which is on the forth row of icons, seven icons from the left.](//discourse-user-assets.s3.amazonaws.com/original/2X/f/fc5d4406b8e794fb973178aeffb281d8e344fea4.png)  

5 . Click the "..." menu, then click "Edit group settings" in the dropdown menu.

![a screenshot telling you to click the "..." button then choose the "Edit group settings" option](//discourse-user-assets.s3.amazonaws.com/original/2X/2/2e6b9e8129a42aba871442045da24686a1a63765.png)

6 . Set the group's privacy setting to public.

7 . Set your group's membership approval to where any member can add or approve members

![a screenshot showing the Facebook settings panel and where you can click to set the group to public and allow all members to be able to add or approve members](//discourse-user-assets.s3.amazonaws.com/original/3X/6/a/6a2735dbb63f052109e06a21baf64d5e818e2dbc.png)  

8 . Click the "Customize Address" button.

9 . Enter "free.code.camp.your.city" with each word separated by periods.  
Examples:  
![:white_check_mark:](https://forum.freecodecamp.com/images/emoji/emoji_one/white_check_mark.png?v=3 ":white_check_mark:") **free.code.camp.london**  
![:white_check_mark:](https://forum.freecodecamp.com/images/emoji/emoji_one/white_check_mark.png?v=3 ":white_check_mark:") **freecodecamp.london**  
![:x:](https://forum.freecodecamp.com/images/emoji/emoji_one/x.png?v=3 ":x:") **free.code.camp.your.london**  
![:x:](https://forum.freecodecamp.com/images/emoji/emoji_one/x.png?v=3 ":x:") **free.code.camp.your.city.london**

![a screenshot telling you to enter freecodecamp.yourcity with each word separated by periods.](//discourse-user-assets.s3.amazonaws.com/original/2X/b/b06ad3f1b9d91f9dd9aba828bdd699677725d130.png)  

10 . Please feel free to personalize your local group's description, but be sure to include a link to freeCodeCamp: `https://freecodecamp.com`. It makes it much easier for possible new members to find you if you mention the country your city is in (or its state/province if in North America).

Also, bear in mind whether your locals may not speak english fluently, and thus having a group in your own language may do a better job at inspiring them to join. We want everyone to feel comfortable, and coding can be difficult enough without having the pressure of having to speak a different language on top of it.

![A screen shot showing you the group description box on the Facebook page.](//discourse-user-assets.s3.amazonaws.com/original/3X/8/c/8c68d711a85d5089b28d927665db3a6d6cf7ca40.png)

11 . Click the "Upload a photo button. To start out, you'll probably just want to use freeCodeCamp's banner (download it <a href='https://github.com/FreeCodeCamp/wiki/blob/master/deprecated%20wiki/images/FCC-FBbanner.png' target='_blank' rel='nofollow'>here</a>), or a scenic shot of your city. Later you can update this with a picture from one of your city's freeCodeCamp events.

Alternatively, Justin being your assistant admin, you can ask him to add the logo from his photo album for you.

[![A screenshot showing the "Upload a photo" button.](//discourse-user-assets.s3.amazonaws.com/original/2X/2/26006223f5f5b1c154496452037049be1a795d68.png)

12 . If you haven't already, **make sure to add <a href='https://www.facebook.com/FCC.GroupChancellor' target='_blank' rel='nofollow'>Justin</a> to your group and then make him an additional admin** so he can add you to the official list —you'll be able to do this after adding him, in the members section, clicking on the gear icon next to his name.  
No need to "friend him" if you didn't do it on step 0\. Just send him a private message with the link to your group and he'll join by himself.  
_Don't worry, the group is still a 100% yours, as he'll just be quietly helping you in the background._

As explained earlier, Justin is in charge of freeCodeCamp's local groups and you can always private-message him if you have further questions or need help with something group-related.

13 . And finally, join our <a href='https://www.facebook.com/groups/freecodecampers/' target='_blank' rel='nofollow'>Local Leaders Facebook group</a>, where we share ideas about involving campers in your city.  

**Additional tips:**

*   Read <a href='https://medium.freecodecamp.com/jump-start-your-local-campsite-with-coffee-and-code-a8d1a57d30e#' target='_blank' rel='nofollow'>this article</a> and see if you can set up your groups's first Coffee and Code session.
*   Some <a href='https://medium.freecodecamp.com/growth-hacking-your-free-code-camp-group-8cf76300a5d1#' target='_blank' rel='nofollow'>ideas on getting more people</a> involved with your group.
