---
title: How to Pick a Linux Distribution and Install
---
While most vendors provide one OS that gets incremental updates and new versions over time (e.g. Windows, Mac OSX, Solaris), Linux has hundreds of different versions to choose from created by different vendors. This is in part because Linux is freely-distributed code which can be tailored to specific user's needs. While the <a href='https://en.wikipedia.org/wiki/Linux_kernel' target='_blank' rel='nofollow'>Linux kernel</a> typically stays the same (core functionality of the OS handling tasks like network management, disk usage, memory utilization, I/O etc.), the many different versions of Linux differ in parts such as which GUI it uses (i.e. <a href='https://www.gnome.org/' target='_blank' rel='nofollow'>Gnome</a>, <a href='https://www.kde.org/' target='_blank' rel='nofollow'>KDE</a>, <a href='http://www.xfce.org/' target='_blank' rel='nofollow'>XFCE</a>, or none at all), system tools, environments, package managers, and applications provided. This unique collection of software along with the kernel define what we call a <a href='https://en.wikipedia.org/wiki/Linux_distribution' target='_blank' rel='nofollow'>Linux Distribution</a> (distro for short).

Opinions on which distribution to choose varies between users, but it is best to choose one that has a seamless installation procedure and is regularly updated with vulnerability and bug fixes. Popular mainstream Linux distributions like <a href='http://www.ubuntu.com/' target='_blank' rel='nofollow'>Ubuntu</a>, <a href='https://www.linuxmint.com/' target='_blank' rel='nofollow'>Mint</a>, and <a href='https://getfedora.org/' target='_blank' rel='nofollow'>Fedora</a> have this covered. These all have great support and a large collection of available software to use for free. Another item to consider is language support, some distributions have better support in specific languages than others. For example, <a href='https://en.opensuse.org/Main_Page' target='_blank' rel='nofollow'>OpenSUSE</a> has strong support for the German Language, and <a href='http://www.ubuntu.com/desktop/ubuntu-kylin' target='_blank' rel='nofollow'>Ubuntu Kylin</a> is a subversion of Ubuntu that was more suitable for Chinese users using Simplified Chinese. Check <a href='http://distrowatch.com/search.php' target='_blank' rel='nofollow'>DistroWatch</a> to search for support in other languages.

Most versions of Linux have a feature that allows the user to test out the distribution before installing it to disk in what is called a <a href='https://en.wikipedia.org/wiki/Live_CD' target='_blank' rel='nofollow'>live CD</a> or a <a href='http://www.linuxliveusb.com/' target='_blank' rel='nofollow'>live USB</a>. A user can put a smaller version of the distribution either burned onto a CD/DVD or a USB drive and boot from it. It will leave a user's current OS intact but they are free to experiment with the user interface and some of the applications. Most distributions will provide a way of using live media first for testing, and later while using the live media be given an option to install the OS onto disk permanently.

For users wishing to keep their current OS or not wishing to make a full transition, another option is to create a virtualized environment and install Linux in it using a tool such as <a href='https://www.virtualbox.org/wiki/Downloads' target='_blank' rel='nofollow'>VirtualBox</a>. A user can run their current OS and have a VirtualBox window running with a Linux distribution in it. This would be an ideal situation for someone who wants to keep running Windows or OSX, but still have access to a Linux environment.