---
title: How to Report a Bug
---
Thank you for taking the effort to report an issue with freeCodeCamp.

If you think you've found a bug on freeCodeCamp, please follow these steps to resolve your problem:

1.  Try resetting the code in the editor using the reset button on the page. This will solve most of the issues if somehow you changed some code, that is affecting the challenge in some way. Resetting clears the code to its original state as if the challenge was first presented to you.

2.  If the page seems broken in any way, try to do a <a href='http://forum.freecodecamp.com/t/refresh-your-browser-cache/19365' target='_blank' rel='nofollow'>Hard Refresh</a> of the page. This will update any old code that may have been cached in your browser.

    *   If your code crashes your browser, also try <a href='http://forum.freecodecamp.com/t/removing-all-locally-stored-challenges/19129' target='_blank' rel='nofollow'>Clearing Your Browser's Local Storage</a>.

3.  <a href='http://forum.freecodecamp.com/t/how-to-get-help-on-gitter/19130' target='_blank' rel='nofollow'>Ask for Help the Chat Rooms</a>. You can usually get a quick response from a helpful community member there.

4.  <a href='http://forum.freecodecamp.com/' target='_blank' rel='nofollow'>Ask for Help on Forum</a>. Occasionally you may see that your queries are not addressed on the chat right away, or it may be something that needs a discussion. In that case, make sure you search this forum for your issue and if you fail to find and satisfactory answer, then ask it here.

5.  If your problem has baffled everyone in chat rooms and the forum, try <a href='http://forum.freecodecamp.com/t/searching-for-existing-issues-in-github/18390' target='_blank' rel='nofollow'>Searching for Your Issue on GitHub</a> for anyone who has posted about a similar issue. If someone has, you can upvote the issue by clicking the (![:thumbsup:](https://forum.freecodecamp.com/images/emoji/emoji_one/thumbsup.png?v=3 ":thumbsup:")) icon on the opening post (first post) in the issue thread.

6.  If you can't find any relevant issues on GitHub, then <a href='http://forum.freecodecamp.com/t/creating-a-new-github-issue/18392' target='_blank' rel='nofollow'>Create a New Issue</a> and our development team will take a look at your problem.

**MOBILE DEVICES:**  
Some challenges may not work on mobile devices (mobile browsers), we try our best to support them, but we recommend that you try and check the challenge on a desktop browser before confirming as a bug.

**IMPORTANT:**  
Before you report a new issue always get a third party confirmation from someone in the chat rooms or the forum. Remember that the issue tracker is strictly for reporting bugs or enhancements, it's not a place to seek any help with solving the challenges.