---
title: Installing Flask in Virtual Environment
---
If you wish to use Flask, you are in the right place! But install Flask, only because you want to explore web development in Flask. We would always recommend Django over Flask, because it gets difficult to build large web-applications in Flask; if you are new to web development in Python.

Flask is a micro-framework; and you can pick the functionality you wish to have over the basic barebone functionality you already have from a standard web-framework. But if you don't wish to do all the hassle and focus on building your idea; perhaps <a>Django</a> would be a better company for the road ahead.

I am going to assume you have **not** skipped the section on installing Python 3 and using it inside a virtual environment.

First make sure that you are not inside a virtual environment already. Then create a new virtual environment, named `py3-flask`

    $ mkvirtualenv py3-flask --python=/usr/bin/python3

Now, execute the `workon` command to see a list of virtual environments in your machine. This should list `py3-flask` in a line.

After this, activate this environment:

    $ workon py3-flask

Your virtual environment would be activated with a copy of Python interpreter, with Python 3 properties. You should run

    $ python --version

to ensure that you are indeed inside a Python 3 environment.

Just to be clear, if you have already installed Django following the previous section - it should **not** be in this environment. We are using virtual environment; to keep our installation of different frameworks separated.

To be sure, run

    pip freeze

Make sure Django is not listed in the output list generated by above command.

Now, let's install Flask. For your peruse, here's the <a href='http://flask.pocoo.org/docs/0.10/installation/' target='_blank' rel='nofollow'>official installation guide</a>. However, a lot of developers prefer installing some extra packages with Flask; for more functionality.

To install just Flask, exeute

    $ pip install flask

When you run `pip freeze` again, it should show you `Flask` in listed packages.

It is cumbersome running long commands like this. Fortunately, there is something like `package.json` in Python domain as well - a list of dependencies, which the package manager can use to duplicate the environment by downloading them with proper version from central repo.

The standard is to use `pip freeze` and log the output to a local file, which can be source controlled.

    $ pip freeze > requirements.txt

Here's the content of `requirements.txt` from my environment, after installing those Flask packages. You may add or remove more packages as your application grows; but for now, just copy paste the content of the following in a text file in the same directory as you are in.

    Babel==2.2.0
    Flask==0.10.1
    Flask-Babel==0.9
    Flask-Login==0.3.2
    Flask-Mail==0.9.1
    Flask-OpenID==1.2.5
    Flask-SQLAlchemy==2.1
    Flask-WTF==0.12
    Flask-WhooshAlchemy==0.56
    Jinja2==2.8
    MarkupSafe==0.23
    SQLAlchemy==1.0.12
    Tempita==0.5.2
    WTForms==2.1
    Werkzeug==0.11.4
    Whoosh==2.7.2
    blinker==1.4
    coverage==4.0.3
    decorator==4.0.9
    defusedxml==0.4.1
    flipflop==1.0
    guess-language==0.2
    itsdangerous==0.24
    pbr==1.8.1
    python3-openid==3.0.9
    pytz==2015.7
    six==1.10.0
    speaklater==1.3
    sqlalchemy-migrate==0.10.0
    sqlparse==0.1.18

This list of packages are taken from <a href='http://blog.miguelgrinberg.com/post/the-flask-mega-tutorial-part-i-hello-world' target='_blank' rel='nofollow'>here</a>.

Once you have saved the file, just run

    $ pip install -r requirements.txt

The package manager would take care of installing missing packages for you! And you should commit this file with your source control system.

The above set of commands assume that you have a Linux machine or Mac OSX machine; or you are using a cloud-hosted box on cloud9 or Nitrous; or maybe you are using a Vagrant box.

But, if you have to use a Windows machine, do consider using Windows Powershell, instead of Windows CMD. Most of the commands would be same. In case you need any assistance, you might want to check <a href='http://stackoverflow.com/questions/17917254/how-to-install-flask-on-windows' target='_blank' rel='nofollow'>this Stack Overflow discussion</a>.