---
title: Interview Questions for Junior Front End Web Developers
---
The purpose of this article is to familiarize fresh Front-End Web Developers with text book questions. If you are just getting into the developer world there is a good chance you will feel nervous when interviewing for a developer's positon. Because of this, some relatively basic questions could feel more difficult than how they actually are. A good counter for this scenario is to be properly prepared.

## Questions

Without further ado, here are a few questions that you could encounter:

### HTML/CSS

1.  In the context of CSS styling can you explain what does `display-style: inline-block` stand for?
2.  If you have a `<ul>` element with several `<li>` elements, how would you go about setting up these elements in a row by using HTML and CSS?
3.  In CSS styling when would you use `float`s? How do they work?
4.  When would you use: `clear: both;`?
5.  What is Bootstrap? When would you use it? How does its grid system work?
6.  Explain the notion of responsive design and how it works? Use an example if you like.
7.  What is a DOM? What do you know about it?
8.  What is SASS? What are the advantages of using it?

### JavaScript

1.  What is ECMAScript?
2.  What is jQuery and what is it commonly used for?
3.  What is the difference between `==` and `===` in JS?
4.  Can you enumerate all JavaScript data types?
5.  What is a callback function in JS and when would you use one?
6.  What is the difference between `undefined` and `null`?
7.  What is an async response?
8.  What does JSON stand for? What is it used for?
9.  How would you explain an API request?
10.  What APIs have you worked with?
11.  How would you send out/convert to JSON format?
12.  What is the difference between `GET` and `POST` when specifying an AJAX request?

### Software/Tooling

1.  Have you worked with Photoshop as a front end developer? For what purpose?
2.  What software versioning system have you used? Could you describe how a workflow would look like in this system?

### About You

1.  What was the hardest project you ever worked on? Why was it difficult? If it is an application/algorithm can you explain how it works?
2.  How do you stay up to date with technology news?
3.  What side projects have you been working on?
4.  Are there any languages or frameworks that you would like to learn in the future? How would you go about teaching yourself? Why did you pick those languages/frameworks?
5.  What are the most important skills and qualities that a junior front end developer should have?
6. Have you ever worked with a team to complete a project? If so, what role did you play on the project? What did you enjoy about working on a team? What issues did you encounter?
