---
title: Jazzing Up the Terminal
---
Out of the box, the terminal shipped with Ubuntu is a bit bland. This section will let you become a power-user ![:muscle:](//forum.freecodecamp.com/images/emoji/emoji_one/muscle.png?v=2 ":muscle:").

## Tools:

#### Terminator

<a href='https://launchpad.net/terminator' target='_blank' rel='nofollow'>Terminator</a> lets you arrange multiple terminals in a grid-like interface.  
To install Terminator enter `sudo apt-get install terminator` into the terminal.

Screenshot of Terminator:

![Screenshot of Terminator](//discourse-user-assets.s3.amazonaws.com/original/2X/6/6af4988ebfb1835ff3c19366865eaaaaf224cb19.png)

#### Oh My ZSH!

Prerequisites:  
- `git` should be installed

To install `ZSH` and `Oh My ZSH!` use the following commands:

    sudo apt install zsh && chsh -s $(which zsh)

> Note: you will need to log out and in again to use ZSH instead of bash as your default shell.

    sh -c "$(curl -fsSL https://raw.githubusercontent.com/robbyrussell/oh-my-zsh/master/tools/install.sh)"

Once you restart your terminal, `Oh My ZSH!` should be installed.

Checkout the <a href='https://github.com/robbyrussell/oh-my-zsh/wiki' target='_blank' rel='nofollow'>Official Documentation</a> to learn how to install plugins and themes.

#### Advanced Tutorials

*   <a href='http://cli.learncodethehardway.org/book/' target='_blank' rel='nofollow'>The Command Line Crash Course</a>
*   <a href='https://github.com/jlevy/the-art-of-command-line' target='_blank' rel='nofollow'>The Art of Command Line</a>
*   <a href='https://www.learnenough.com/command-line-tutorial' target='_blank' rel='nofollow'>Learn Enough Command Line to Be Dangerous</a>

![:point_left:](//forum.freecodecamp.com/images/emoji/emoji_one/point_left.png?v=2 ":point_left:") Previous | ![:book:](//forum.freecodecamp.com/images/emoji/emoji_one/book.png?v=2 ":book:") Home ![:book:](//forum.freecodecamp.com/images/emoji/emoji_one/book.png?v=2 ":book:") | Next ![:point_right:](//forum.freecodecamp.com/images/emoji/emoji_one/point_right.png?v=2 ":point_right:")  
[**Customising Ubuntu**](//forum.freecodecamp.com/t/customizing-ubuntu/18382) | [**Table of Contents**](//forum.freecodecamp.com/t/setting-up-ubuntu-for-programming/18388) | [**Installing DevTools and modern web browsers**](//forum.freecodecamp.com/t/installing-devtools-and-modern-web-browsers/18385)
