---
title: MaterializeCSS Framework as an Alternative to Bootstrap
---
<a href='http://materializecss.com/' target='_blank' rel='nofollow'>MaterializeCSS</a> is a modern responsive front-end framework based on google's <a href='https://www.google.com/design/spec/material-design/introduction.html' target='_blank' rel='nofollow'>Material Design principles</a>.

## What is Material Design?

Material Design (codenamed Quantum Paper) is a design system developed by Google. Expanding upon the "card" motifs that debuted in Google Now, Material Design makes more liberal use of grid-based layouts, responsive animations and transitions, padding, and depth effects such as lighting and shadows.

This <a href='https://www.youtube.com/watch?v=Q8TXgCzxEnw' target='_blank' rel='nofollow'>video</a> gives you an idea about material design:

## Check out these websites that use Materialize and see the difference from what you're used to!

Test them on your phone too for a better feel.

*   <a href='https://www.100xp.io/' target='_blank' rel='nofollow'>The 100</a>

*   <a href='http://demo.geekslabs.com/materialize/v2.1/' target='_blank' rel='nofollow'>Admin Themes</a>

*   <a href='http://www.straphq.com/' target='_blank' rel='nofollow'>StrapHq</a>

More examples <a href='http://materializecss.com/showcase.html' target='_blank' rel='nofollow'>here</a>

## A Bootstrap alternative, really?

Chill, nothing can ever beat Bootstrap, in my opinion. However, materialize CSS offers just that, Materialize-ation - The feeling of interacting with the interface as if its a physical material, like paper. I just came up with that.

But really...

I do like materialize because of its simplicity, for example:

In Bootstrap you would do this to create a button

    <button class="btn btn-primary btn-lg">
    My Button
    </button>

Basically each class name repeatedly has the btn- attached to it. And this is mostly the case for many other bootstrap components especially when you want to add simple classes like color.

With Materialize you can add all the classes simply like this:

    <button class="btn waves-effect waves-light green">My Button</a>

As you can see, use of the btn- has been reduced. The `green` class can be re-used with any/all other HTML element other than the `button` shown in this case.

There is another lighter version of material Design Framework but its not as elegant or simple as the materializeCSS framework Other than this simplicity, here are more reasons why I love materializeCSS:

*   It's simple! -- Just emphasizing
*   It's open-source, you can git it here
*   A community is also growing around it
*   <a href='http://fezvrasta.github.io/bootstrap-material-design/' target='_blank' rel='nofollow'>Someone</a> is looking to produce a blend of Bootstrap + Materialize. Sweeet!

## Anything else?

Try it out and maybe you will love it. In fact since thats where even android UI is already headed, this might a good way to get yourself better at Material design for mobile-focused web-apps like <a href='https://developers.google.com/web/fundamentals/getting-started/your-first-progressive-web-app/#what-will-you-learn' target='_blank' rel='nofollow'>progressive web apps</a>

### Maybe you shouldn't use it ...yet

It's undergoing changes being at alpha stage. So you might skip it and not use it on crucial project until it matures.
