---
title: Online vs Offline IDEs
---
## Offline IDEs

There are several offline <a>**IDE**</a>s that programmers use in order to stay more productive to learn and be more productive at work.

*   <a href='https://www.app5.unisys.com/offerings/ClearPathConnection/eclipse.html' target='_blank' rel='nofollow'>**Eclipse**</a> is more than a Java editor. Its biggest advantages are code completion by tabbing method, which saves a lot of time when writing documentation.

It has a built-in syntax check to fix any mistyped words while coding a project. The features we've come to expect of an IDE are their code completion, templates, integration with various SCMSs, and integration with build systems.

The IDE's code formatting and cleanup tools are very powerful. I find its build system to work well and intuitively. I think these are the things upon which its reputation is really built.

Furthermore it has a refactoring function, a find and replace function, variables and classes of a specific project.

*   <a href='https://netbeans.org/features/' target='_blank' rel='nofollow'>**NetBeans**</a> is a free intuitive editor that does it all. It has a simple "Swing GUI" design tool to build user interfaces by dragging and dropping components, for instance buttons or textboxes.

One _disadvantage_ is that with all its features loading times increase and more memory is being used, compared to other IDEs.

*   <a href='https://www.jetbrains.com/idea/' target='_blank' rel='nofollow'>**IntelliJ IDEA**</a> is the most efficient offline editor, however it's not free. It is faster than most editors, yet it has numbers of problems. One major advantages is that it uses too much memory.

*   <a href='http://www.bluej.org/' target='_blank' rel='nofollow'>**BlueJ**</a> is a simple editor mostly used to teach java and object oriented programming. The main advantage of this editor compared side-by-side to other IDEs is that it does not need a main method to run the program.

## Online IDEs

*   <a href='http://www.webappers.com/2009/12/04/coderun-studio-free-cross-platform-online-ide/' target='_blank' rel='nofollow'>**CodeRun Studio**</a> is an online IDE that lets you build web applications. It allows you to run and test code online.

This IDE will allow you to use it for a 14-day trial period before you need to pay to continue to use it. The "save" function is also disabled during the trial period, making it harder to use this program.

*   <a href='https://c9.io' target='_blank' rel='nofollow'>**Cloud9 IDE**</a> Cloud9 IDE is a open source, version 3.0 and onwards, online integrated development environment. It supports hundreds of programming languages, including PHP, Ruby, Perl, Python, JavaScript with Node.js, and Go. It enables developers to get started with coding immediately with preset workspaces, collaborate with their peers using collaborative coding features, and web development features like live preview ("WYSIWYG" or "What You See Is What You Get") and browser compatibility testing.

It is written almost entirely in JavaScript, and uses Node.js on the back end. The editor component uses Ace. As of July 2014, it uses Docker containers for its workspaces, and is hosted on Google Compute Engine.

Cloud9 IDE, Inc. is the company that actively maintains Cloud9 IDE. The company has offices in San Francisco and Amsterdam.

## Conclusion

There are several differences between online editors and the offline editors.

An offline IDE may be more beneficial to a programmer rather than an online IDE. Not only might large projects take up a lot of memory causing your machine to slow down. If you're working in a team you will need a reasonably fast internet connection to push updated code quickly. If there is a major storm and your internet connection is affected by it, it will cause your projects to be unfinished and incomplete if an online IDE is used.

The only advantage of an online IDE is that projects can be accessed everywhere, no setups and configurations are necessary. There is no hardware limitation since all information is be stored in the cloud.
