---
title: Programming Methodology
---
### Foundational Agile Principles

**_Individuals and interactions_** over **_Processes and tools_**

**_Working software_** over **_Comprehensive_**

**_Customer collaboration_** over **_Contract negotiation_**

**_Responding to change_** over **_Following a plan_**

## User-Stories

User stories help us tie the needs of our users directly to features we implement in a conversational format. They **always** follow this syntax: _"As a User/Stakeholder, I need/want to be able to Do Something"_. This can result in some awkward stories for the "obvious" features like _"As a user, I need to be able to trust that my credit card information is secure."_, but it is imperative that ALL features tie back to a story in order to allow us to effectively break the work down into manageable pieces.

## Sprints

A "Sprint" is a short (1-3 weeks) development cycle during which a number of stories or subtasks are targeted for completion by the end of the sprint. The idea behind "Sprinting" is to allow us to **deliver** a story to the project champion for feedback/approval. This iterative workflow ensures we get continuous buy-in from the project champion and we are delivering functionality that both works, and is valuable.

## SCRUM

At a basic level, SCRUM helps us stay focused and informed about what the status is on each assigned task as well as break down communication barriers. In many professional settings the work day begins with a "Daily Scrum". We will be following a weekly scrum to align with our sprints. A common scrum failure is to attempt to problem solve during a scrum. Troubleshooting and brainstorming should always be done as a separate task from SCRUM.

Read more <a href='http://scrummethodology.com/' target='_blank' rel='nofollow'>here</a>.