---
title: Site Improvements for October 2015
---
Our open source community has been hard at work throughout September on some major improvements. We're going to keep up this tempo, and do a special live stream for our first birthday (October 15, 2015). Here are the improvements we just pushed to production:

## Certification

*   New challenges have appeared called "Claim your Front End Developer Certificate" and "Claim your Full Stack Developer Certificate".
*   We've built acceptance of our <a>Academic Honesty Policy</a> into these certificate challenges.
*   Certificates are issued programmatically once you meet their requirements.
*   Certificates are available right from your Code Portfolio, and publicly viewable to all as long as you haven't hidden your solutions.
*   Each certificate has a unique verifiable URL that employers can check. This makes it is impossible to forge our certificates without access to our production servers.

## Code Portfolios

*   All challenges and their solutions now show up on your code portfolio, including Challenges.
*   You can hide your solutions from other people.

## Unauthenticated Campers

*   You can complete all of our challenges without being hassled to log in.
*   Once you complete a challenge, you will be redirected to the next logical challenge, even if you aren't logged in.

## Improved challenges

*   [@berkeleytrue](/users/berkeleytrue) figured out a way to make all challenge solutions 100% sharable. You can copy a URL directly from your browser and share it with others, and they will be able to run your code against the challenge's tests. URLs update automatically when you run a challenge's tests.
*   We completely rewrote all Algorithm tests to be as transparent as possible. By popular request, we no longer show the Chai tests themselves - just a message clearly explaining what each test is testing.
*   By popular request, we added gif-style challenges, and are replacing our video-style challenges with these. All of our old videos will remain available on our <a href='https://www.youtube.com/channel/UC8butISFwT-Wl7EV0hUK0BQ?sub_confirmation=1' target='_blank' rel='nofollow'>YouTube channel</a>.

## Wiki improvements

*   [@rafase282](/users/rafase282) has nearly finished creating <a>notes for every single challenge in Free Code Camp's curriculum</a>, including hints and solutions.
*   [@codenonprofit](/users/codenonprofit) has started creating "portal" style wiki articles that serve as better entry points into our tangle of 400+ articles.

## Resolved experiments

*   Plug.dj shut down, and our plug.dj room with it. Some of our campers are working on building an open source music app to replace it.
*   We delisted several low-traffic casual Gitter rooms from our wiki and created a catch-all <a href='https://gitter.im/freecodecamp/casual' target='_blank' rel='nofollow'>Casual chat room</a> for non-coding-related chat.
*   We now recommend campers use their Local Group's Facebook group for chatting instead of their campsite's Gitter chatroom. Only a few of our Local Group Gitter chatroooms had active synchronous discussions, and about 1/3rd of all conversations consisted of someone saying "hello" and not getting a response. We've delisted all our Local Group Gitter rooms from our Local Group directory. Still, we will keep them open for archival purposes, and you can keep using it if you'd like. Here's a short <a href='http://blog.freecodecamp.com/2015/09/jump-start-your-local-campsite-with-coffee-and-code.html' target='_blank' rel='nofollow'>blog post</a> about how our Local Groups are evolving and growing.

## Other exciting developments

*   We just launched our first-ever <a href='https://teespring.com/get-free-code-camp-t-shirt' target='_blank' rel='nofollow'>t-shirt campaign</a> and added a second campaign for <a href='https://teespring.com/free-code-camp-shirt-eu' target='_blank' rel='nofollow'>EU fulfillment</a>.
*   We just launched Commit. Rather than going into detail on it here, read <a href='http://blog.freecodecamp.com/2015/10/commit-to-yourself-commit-to-nonprofit.html' target='_blank' rel='nofollow'>@codenonprofit's blog post</a>.
*   We launched <a href='http://freecodecamp.com/labs' target='_blank' rel='nofollow'>Free Code Camp Labs</a> to showcase some unique projects our campers are building.
*   We started gathering <a href='http://freecodecamp.com/stories' target='_blank' rel='nofollow'>Stories from campers</a> and putting them all in one place. These are just a fraction of the campers who've advanced their careers and gotten coding jobs after learning with Free Code Camp, but it's a pretty representative sample.

## Improvements coming in the next few weeks:

*   A clickable hint button on each challenge that cycles through a series of increasingly helpful hints.
*   Recommended solutions that you can compare your solution with once you complete each challenge.
*   We'll re-record some of our dated-looking gifs.
*   We'll finish the Get Set for Back End Projects with Clementine.js (gif-style challenge)
*   We'll finish the new Get Set for Front End Projects (gif-style challenge)
*   We'll move all Front End Project and Back End Project challenges to gif-style.
*   We'll add a back button to our gif-style challenges.
*   We'll launch our job board.
*   We'll publish several new JSON API and AJAX-related challenges
*   We'll finish a leaderboard creation mechanic designed for teachers to track students and campers to track their friends.
*   We'll finish the Hikes interface (Hikes are Briana Swift's <a href='https://www.youtube.com/watch?v=q7tlgZg4Q1o&list=PLWKjhJtqVAbmfoj2Th9fvxhHIeqFO7wOy' target='_blank' rel='nofollow'>computer science theory challenges</a>)
*   We'll close the ~30 pull requests that have piled up (thanks, contributors!)

## And longer term goals we still haven't forgotten:

*   Support for major world languages (<a href='https://trello.com/b/m7zhwXka/fcc-translation' target='_blank' rel='nofollow'>translation is still underway</a>)
*   Turning Free Code Camp into a single-page isomorphic app
*   Creating a browser-based replacement for Screen Hero / Team Viewer that is well suited to pairing on Free Code Camp.
*   React.js curriculum
*   D3.js curriculum and data visualization Front End Projects

## Our codebase is improving quickly.

If you see something that looks funky or broken, please click that "bug" button and create a GitHub issue for us. Thanks for your patience and support.

Happy coding!