---
title: The History of Ruby
---
<a href='https://www.ruby-lang.org/en/' target='_blank' rel='nofollow'>Ruby</a> is a dynamic, object-oriented, <a href='https://en.wikipedia.org/wiki/Reflection_(computer_programming' target='_blank' rel='nofollow'>reflective</a>) programming language with a focus on simplicity and productivity. It has an elegant syntax that is natural to read and easy to write. It also has a dynamic type system and automatic memory management.

Known for its <a href='https://en.wikipedia.org/wiki/Syntactic_sugar' target='_blank' rel='nofollow'>syntactic sugar</a>, Ruby is made for developer's happiness. It was created by a Japanese software engineer, <a href='https://en.wikipedia.org/wiki/Yukihiro_Matsumoto' target='_blank' rel='nofollow'>Yukihiro Matsumoto</a> (also popularly known as Matz) as a simple general purpose scripting language for his day-to-day work. Combining elements of Perl, Smalltalk, and Scheme in a simple yet powerful syntax.

Ruby was conceived on February 24, 1993\. In a 1999 post to the ruby-talk mailing list, Yukihiro Matsumoto describes some of his early ideas about the language:

> I was talking with my colleague about the possibility of an object-oriented scripting language. I knew Perl (Perl4, not Perl5), but I didn't like it really, because it had the smell of a toy language (it still has). The object-oriented language seemed very promising. I knew Python then. But I didn't like it, because I didn't think it was a true object-oriented language — OO features appeared to be add-on to the language. As a language maniac and OO fan for 15 years, I really wanted a genuine object-oriented, easy-to-use scripting language. I looked for but couldn't find one. So I decided to make it.

Like Perl, Ruby is good at text processing. Like Smalltalk, everything in Ruby is an object, and Ruby has blocks, iterators, meta-classes and other good stuff. You can use Ruby to write servers, experiment with prototypes, and for everyday programming tasks. As a fully-integrated object-oriented language, Ruby scales well.

By 2000, Ruby was more popular than Python in Japan; but as the <a href='http://rubyonrails.org/' target='_blank' rel='nofollow'>Ruby on Rails</a> web framework was created and released; it grew in leaps and bounds, well beyond Japan.

Today, Ruby on Rails is considered a solid web framework; and it has pioneered lot of great practices in web development.

Similarly a lot of <a href='https://prograils.com/posts/top-10-famous-sites-built-with-ruby-on-rails' target='_blank' rel='nofollow'>popular sites</a> are coded in Ruby on Rails like GitHub, Airbnb, Groupon, etc.

There are various <a href='https://github.com/cogitator/ruby-implementations/wiki/List-of-Ruby-implementations' target='_blank' rel='nofollow'>implementations</a> of Ruby. JRuby (Ruby on the JVM), Ruby MRI (also called CRuby) and IronRuby (Ruby for .NET and Silverlight) are some of the most popular ones.
