---
title: The Net Platform
---
**.NET platform** is a big and comprehensive collection of frameworks and libraries managed by <a href='https://www.microsoft.com/net' target='_blank' rel='nofollow'>Microsoft</a>. C# is the most popular language used to develop a range of .NET applications, such as <a href='http://www.asp.net/' target='_blank' rel='nofollow'>web apps</a>, <a href='https://dev.windows.com/en-us/' target='_blank' rel='nofollow'>windows aps</a>, <a href='https://www.xamarin.com/platform' target='_blank' rel='nofollow'>Mac and iPhone apps</a>.

We will start with learning <a>C# programing language</a>, and will make you familiar with development environment, project structures, techniques, and best practices that you will perform as a professional developer.

First let's begin with a brief overview of the .NET platform, and get some jargons out of the way. Don't worry, you don't have to know in-depth about these at this point.

*   <a href='https://msdn.microsoft.com/en-gb/library/w0x726c2(v=vs.110' target='_blank' rel='nofollow'>.NET Framework</a>.aspx) : (_pronounced dot net_) provides configuration for your application to run on top of it. It provides all the services an app needs; for instance communication with database, networks, file systems which are commonly used to build console, desktop, web, mobile and game applications.
    *   <a href='https://msdn.microsoft.com/en-us/library/8bs2ecf4(v=vs.100' target='_blank' rel='nofollow'>CLR (Common Language Runtime)</a>.aspx) : is an execution environment for your application which manages its life-cycle. CLR provides services like memory management, and is:

    1\. implementation of <a href='http://www.ecma-international.org/publications/standards/Ecma-335.htm' target='_blank' rel='nofollow'>CLI standard(Common Language Infrastructure)</a>
    2\. designed to be platform-independent. Platform refers to the computer architecture and operating system.
    3\. language independent, for instance can be used for C#, C++,<a href='https://msdn.microsoft.com/en-us/library/system.io(v=vs.110' target='_blank' rel='nofollow'>VB.NET][vbnet] and [F#][fsharp].

*   C-Sharp Compiler : a `csc.exe` is a compiler which transforms C# code into Microsoft Intermediate Language (MSIL), commonly referred as IL. It defines instructions which CLR can understand. CLR's job is to read these instructions and tranform them into machine-understandable instructions.

*   Class libraries : It contains thousands of in-built classes for your application's use, for example [`System.IO`</a>.aspx) for reading/writing data streams, <a href='https://msdn.microsoft.com/en-us/library/system.net.http.httpclient(v=vs.118' target='_blank' rel='nofollow'>`HttpClient`</a>.aspx) sends data over network, <a href='http://www.asp.net/' target='_blank' rel='nofollow'>`ASP.NET`</a> for web applications, <a href='https://msdn.microsoft.com/en-us/library/h43ks021(v=vs.110' target='_blank' rel='nofollow'>`ADO.NET`</a>.aspx)for data access to relational databases (like Microsoft SQL Server and MySQL), and <a href='https://msdn.microsoft.com/en-us/library/ms735119(v=vs.90' target='_blank' rel='nofollow'>Windows Communication Foundation (WCF)</a>.aspx) for service-oriented applications which communicates over established protocols like HTTP, REST, SOAP and TCP etc.

*   The C# Programming Language (_pronounced "C-sharp"_) : C# has a syntax similar to Java, C++, and JavaScript. It is:

    1.  used to write applications, services and reusable libraries.
    2.  designed to work with .NET platform.
    3.  strongly typed, high level object oriented language.
    *   <a href='https://blogs.msdn.microsoft.com/dotnet/2014/12/04/introducing-net-core/' target='_blank' rel='nofollow'>.NET Core</a> : is Microsoft's recent endeavour to move towards open source, cross platform development delivered as <a href='https://www.nuget.org/' target='_blank' rel='nofollow'>Nuget</a> packages. They are working with <a href='http://www.mono-project.com/' target='_blank' rel='nofollow'>Mono</a> community, which is an implementation of Microsoft .NET framework to build apps on Windows, Linux, and iOS.

    *   <a href='https://www.microsoft.com/silverlight/' target='_blank' rel='nofollow'>Silverlight</a> : primarily intended to focus on web browsers plug-in to provide enrich multimedia.

    *   <a href='https://dev.windows.com/en-us/' target='_blank' rel='nofollow'>.NET for windows app</a> : used to create Windows 8.x Store apps using C#.

## The C# programing language

Next step to learn the <a>C# programing language</a>.
