---
title: What Is a Sprint
---
A **sprint** is a set period of time broken out from a project's overall timeline with associated tasks to be completed during that period of time. That list of tasks is referred to as the sprint's _Product Backlog_.

The ideology behind a _sprint_ allows a larger timeline to be easily broken into smaller, more digestible pieces in order to focus effort from all stakeholders on a few logically scheduled tasks at a time.

All deliverables from a sprint must be accepted by the key stakeholders prior to moving to the next sprint and a project will have multiple sprints until scope has been met.

In most cases, a _sprint_ begins with a planning meeting where the person or persons requesting the work meet with the developers in order to determine what work can realistically be completed during the time period, or sprint, being discussed. The developer will generally have the final say on what work will be completed during the sprint.

In some organizations these meetings will be overseen by either a Scrum Master or a Project Manager in order to ensure the overall goal of the project has been met after all sprints have been completed.

Sprints, on average, will last as much as 30 days or as little as a 7 days depending upon both the size of the project, the number of tasks to be completed, and the number of resources available to work on the sprint's tasks.

In addition, in some organizations developers will meet daily to discuss project progress, needs, and roadblocks. These meetings are sometimes referred to as SCRUM meeting or Daily Stand-up Meeting. The person or persons are sometimes invited to listen however they are only in attendance as observers. During a stand-up, developers typically answer three questions: 
1. What did you work on yesterday? 
2. What are you working on today?  
3. Are you blocked?

![sprint schedule](https://i.imgur.com/l8EAw1L.png "example of sprint schedule")

The above is an example of a sprint plan which has been laid out in six 30 day sprints. You can see that there is a Sprint Dev in each of the six sprints but from Sprint 2 on there is something labeled as a **Sprint # Increment**.

The Sprint Dev is a representation of the development going on during this sprint while Sprint Increment is a the sum of all product backlog items that were completed in the current sprint and all previous sprints.
