---
title: Mobile Application Development
---

## Mobile Application Development

<img src="https://preview.ibb.co/chfPGv/Whats_App_Image_2017_09_11_at_12_48_41_PM.jpg" alt="hybrid applications" border="0">

This section contains articles related to Mobile Hybrid Applications Development using frameworks such as Apache Cordova, Ionic Framework, and React Native.

## Advantage & Disadvantage of Native vs Hybrid Application

Native App Definition

- Built for a specific operating system and can be accessed only from the dedicated app store
Android apps can only be accessed by Android users and is developed using Java, Windows, C++ etc. 
- iOS apps are developed with XCode on MacOS and use Objective-C or Swift as a programming language
- Development costs and effort are higher

Hybrid App Definition

- Uses Native Device's Browser container to contain HTML5 app
- Developing hybrid app is consistent, cross platform UI

Development Cost and Time

Hybrid apps take least amount of time & money to develop compared to native app.
One code for both platforms.

User Experience

Native apps provide the best user experience in terms of coherent look & feel to the device's specific.
Better performance for Native App compared to Hybrid App

### Apache Cordova

[Apache Cordova](https://cordova.apache.org/) is the wrapper that wraps your HTML, CSS, and JavaScript into a buildable mobile package, acting as the magic that glues everything together and turns it into a mobile app

### Ionic Framework

[Ionic Framework](https://ionicframework.com/) is a CSS framework that allows you to style your screens to look mobile friendly, essentially acting as bootstrap but for mobile apps while developing using web technologies.

### React Native

[React Native](https://facebook.github.io/react-native/) is a front end development framework that contains a lot of the building block elements for Android/iOS development and is a different kind of magic from Apache Cordova. React Native lets you build native mobile apps using JavaScript. It uses the same design as React, letting you compose a rich mobile UI from declarative components.

### NativeScript

Originally created by Progress, [NativeScript](https://www.nativescript.org/) apps are built using JavaScript, or by using any language that transpiles to JavaScript, such as TypeScript, for instance. NativeScript directly supports both Angular and Vue frameworks via a community-developed plugin. Mobile applications built with NativeScript result in fully native apps, which use the same APIs as if they were developed in Xcode or Android Studio.

### Flutter

[Flutter](https://flutter.io/) is a cross platform mobile development framework from Google. It can be used to create both iOS and Android apps with ease. It uses Dart as its primary language. Its hot reload feature helps in speeding up the overall development process. Flutter produces real native apps as in the case of React Native as opposed to Cordova and Ionic, which produce hybrid apps.

### Xamarin

[Xamarin](https://visualstudio.microsoft.com/xamarin/) is a cross platform mobile development framework from Microsoft. It allows you to develop on a PC or a MAC using a C# codebase. You can create Native iOS Apps, Native Android Apps, and Native Windows Phone Apps. You can use either Visual Studio or Xamarin Studio as the IDE to develop using Xamarin.
