---
title: Mobile app development
---

### Introduction to App Development
One of the more popular forms of coding in recent times is the creation of applications, or apps, that run on mobile devices like phones and tablets. You probably use a range of different apps in your everyday life. Wouldn’t it be cool to create one of your own?
There are many perks of being a developer in the booming app industry. Quite a few people make a good living developing and selling apps, and you have the opportunity to be one of them. You could even become the next Nick D’Aloisio, who famously sold his iPhone app, Summly, to Yahoo! for $30m.
Plus, it’s the best way to get your work into people’s pockets!

### App Development Overview
Mobile apps are developed for a certain platform, and the two most popular platforms today are iOS and Android.
The iOS platform powers apps built for iPhone and iPad. To develop an app for iPhone or iPad, you need to use the Objective-C coding language and the Cocoa framework. You also need to use an IDE (integrated development environment) called Xcode. Note that Xcode only runs on the Mac, so you will need a Mac to make an iOS app.Android apps are developed with the Java coding language and the Android Software Development Kit, which runs on Mac, PC or Linux. You also need to use an IDE such as Eclipse.There are other mobile platforms such as Windows Phone, but iOS and Android are definitely the most popular. Most training focuses on these platforms.

#### iOS (iPhone, iPad)
iOS is a mobile operating system developed and distributed by Apple Inc. It was originally released in 2007 for the iPhone, iPod Touch, and Apple TV. iOS is derived from OS X, with which it shares the Darwin foundation. iOS is Apple's mobile version of the OS X operating system used in Apple computers.

#### Ionic
Ionic is open source framework used for developing mobile applications. It provides tools and services for building Mobile UI with native look and feel. Ionic framework needs native wrapper to be able to run on mobile devices. This is an introductory tutorial, which covers the basics of the Ionic Open Source Framework and explains how to deal with its various components and sub-components.

#### Android
Android is an open source and Linux-based operating system for mobile devices such as smartphones and tablet computers. Android was developed by the Open Handset Alliance, led by Google, and other companies. This tutorial will teach you basic Android programming and will also take you through some advance concepts related to Android application development.

#### Xamarin
Xamarin is a software company based in San Francisco. It provides commercial software development tools that allow a user to develop applications for Android, iOS and Windows using C# language and the .NET framework. Xamarin is built on the .NET Framework. It allows one to create apps that easily run across multiple platforms. In this tutorial, we will explain how you can use Xamarin to deliver native iOS, Android, and Windows Apps.

#### PhoneGap
PhoneGap is a software development framework by Adobe System, which is used to develop mobile applications. To develop apps using PhoneGap, the developer does not require to have knowledge of mobile programming language but only web-development languages like, HTML, CSS, and JScript. PhoneGap produces apps for all popular mobile OS platforms such as iOS, Android, BlackBerry, and Windows Mobile OS etc. In this tutorial we will focus on developing App for Android platform. This tutorial will give you adequate information about how to produce apps quickly using PhoneGap services.	

#### React Native
React Native just like PhoneGap and cordova offers the opportunity for Web Developers to step into the world of Mobile App Development. It is a cross platform mobile application framework from Facebook i,e one can build apps for the Android and ios platform using JavaScript (JSX). As opposed to those hybrid apps produced by cordova and phonegap, React Native produces real native apps which can utilise all the native features. It comes with the tagline, "Write once, run everywhere". Usually Tech companies used to had separate teams who would maintain the codebase for ios and android. React Native solves this problem in an effective way allowing Web Developers with React background to build awesome mobile apps. To go on with this track, get started with React. One should be familiar with all those concepts like components, states, props, routing etc. before jumping into React Native. It is also good if one can create bunch of projects in React so as to familiarise with the JSX syntax and all other stuffs which would certainly benefit when it comes into React Native.

#### PowerApps
Launched in 2017, PowerApps is a browser-based platform by Microsoft that allows developers and non-developers to build mobile applications from selectable templates or from a blank canvas. PowerApps at its core is a Platform as a Service. It allows you to create Mobile Apps that run on Android, iOS, Windows (Modern Apps) – and with almost any Internet browser. It takes care of the differences between the operating systems and just allows you to run your apps. It is essentially a container that makes mobile apps much easier to use across mobile platforms. PowerApps offers to dramatically accelerate how business apps are built, reducing time to solution from weeks or months to minutes and empowering a new category of app creators.

