---
title: Network Engineering
---
## Network Engineering

A **packet** is an abstraction of transmitted data in the *Network layer* of the OSI model. It consists of the actual data along with other fields neccessary for it's mediation from one node to another node in the network. Since transferring all the data together over a network at one go is inefficient, it is broken down into small packets and then passed on. 

A packet looks like this:

![packet](https://www.computerhope.com/jargon/p/packet.jpg)

The Network Layer breaks down the data into small packets, each with it's unique identifier. They are then passed onto the Transportation Layer which transports them to the destination through several intermidiate nodes like routers and switches, using the *Transmission Control Protocol* (TCP) and *Internet Protocol*(IP). TCP deals with the actual routing to an application while IP helps in logical addressing of devices (IP address) to keep a track of which node to send the packet next to.

Once the packets reach the destination, an acknowledgement is sent back. If for any reason a packet is dropped, it can be requisitioned again from the source node.    




Network engineers are responsible for implementing, maintaining, supporting, developing and, in some cases, designing communication networks within an organisation or between organisations.

Their goal is to ensure the integrity of high availability network infrastructure to provide maximum performance for their users. Users may be staff, clients, customers and suppliers. Networks can include:

computer;
voice;
firewall.

Network engineers may work internally as part of an organisation's IT support team, or externally as part of an outsourced IT networking consultancy firm working with a number of clients.
