---
title: Socket.io
---

## Socket.io

[Socket.io](https://socket.io/) is a Node.js library made to help make real-time communication between computers possible. To ensure this Socket.io uses a combination of WebSockets and Polling to establish a connection between the client's browser and the server. This allows it to work on older browsers that may not support pure websockets. This library uses [Engine.IO](https://github.com/socketio/engine.io) for building the connection.

### Demos

To get a taste of what is possible, Socket.io provides two demos to show it's possible use-cases. You can find the demos at [https://socket.io/demos/chat/](https://socket.io/demos/chat/) and find the link to the whiteboard demo on the left.

### Get Started 

Since Socket.io is a Node.js library, you have to make sure that Node.js is installed on your computer. 
If it's not set up yet get the latest version at [Nodejs.org](https://nodejs.org/)

#### macOS

Node.js can also be installed via [Homebrew](https://brew.sh/) a package manager for macOS.

Just type `brew install node` to install Node.js.  

A [get started](https://socket.io/get-started/chat/) guide can also be found on Socket.io's page. It shows how to easily build a real-time chat in just a couple of lines.

#### More information

More information about Socket.io and it's documentation can be found at:
- [Socket.io](https://socket.io/)
- [Socket.io Documentation](https://socket.io/docs/)
