---
title: PHP tags
---

When PHP parses a file, it looks for opening and closing tags, which are `<?php` and `?>` which tell PHP to start and stop interpreting the code between them. Parsing in this manner allows PHP to be embedded in all sorts of different documents, as everything outside of a pair of opening and closing tags is ignored by the PHP parser.

Note: using capital letters in tag declaration `<?PHP` goes against the PSR-1 basic coding standard and should not be used.

PHP also allows for short open tag `<?` (which is discouraged since it is only available if enabled using the `short_open_tag php.ini` configuration file directive, or if PHP was configured with the `--enable-short-tags` option).

If a file is pure PHP code, it is preferable to omit the PHP closing tag at the end of the file. This prevents accidental whitespace or new lines being added after the PHP closing tag, which may cause unwanted effects because PHP will start output buffering when there is no intention from the programmer to send any output at that point in the script.

```php
<?php
echo "Hello world";

// ... more code

echo "Last statement";

// the script ends here with no PHP closing tag
```
