---
title: Creative Briefs
---
## Creative Briefs

**1. What is a Creative Brief? Why is it needed? Who’s it for?**

A creative brief ("CB") is a project document, referenced much like a project brief, helpful during kickoff with the production team. It’s used in agencies, startups and big software companies, by creative teams of all sizes. It’s serves as a roadmap representing the vision, project goals, it describes the audience and outlines the brand guidelines you’ll be working within; it answers the question of “how does the brand behave in the world?” It may even include details about deliverables, both from stakeholders/client (content, brand guidelines, analytics…) to creative team, and vice versa. It is to inform and inspire, not restrict. It is a liberating tool because it succinctly defines what is needed from creative.

**2. When is it authored, and by whom?**

When a new project comes in, typically there is a period of discovery where initial project scoping and definition docs* are authored, these being the high-level project brief, requirements-gathering for functional, technical, creative and brand requirements, etc. The seeds of a creative brief come from this initial discovery phase, and is a defined step of discovery, generally occurring after these aforementioned docs are completed (the CB is roughly informed by what is gathered in these preceding conversations with stakeholders/clients).

CB’s are usually authored by the production team’s Creative Director. They lead the session/s in which the information is gathered for the brief, as well as any iterations thereof. They are also responsible for disseminating the final brief to the creative team, ensuring the end product reflects the client-authorized/approved brief. The CB might be drafted by a Director of Product, Product Lead, Product Manager, etc., as these roles/titles are in flux these days. The goal is for the creative lead to also have a mind for business and brand, as well.

*NOTE: While there is a good amount of information to communicate in all discovery docs, you should also be able to distill each into a page or two, at most. A brief is, in fact, literally brief.*

**3. What does a good brief look like?**

You know now that a good CB is critical to the success of your project. It’s the detail in a creative brief that really helps the team deliver. The clearer the brief, the better they’ll understand the client and the brand, and the better able they’ll be to capture the message and overall vision on the first try.

**4. Tips for writing a creative brief:**

The Process:

1. One of the best ways to develop a brief is collaborating with the client in the room– shaping the brief in real time. Invite just the key stakeholders and leads on the production team (usually Proj. Mgr., creative and art directors, technical lead, UX lead, marketing/biz lead). Creative Director drives the meeting, but all members listen/participate (and support the CD) by pursuing clarity and/or supplying example scenarios to further refine direction, message, vision, market awareness, etc.

2. Use a whiteboard and follow the worksheet (sample enclosed), prompting all the right questions. Encourage organic discussion, stream of consciousness from the client. Listen more than talk – this is critical. This session is client-centered. Drill in to get more details, if you need more clarity. This is critical-phase for drafting the brief.

3. If you are new to writing CB’s, reference sample real world creative briefs to learn how answers are phrased, understand language used, thought process and framing.

<!-- The article goes here, in GitHub-flavored Markdown. Feel free to add YouTube videos, images, and CodePen/JSBin embeds  -->

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
- [Sample Real World Creative Brief](http://bit.ly/2zBGUX5)
- [Creative Brief Worksheet](http://bit.ly/2y4x7HV)
