---
title: Data Driven Design
---
## Data Driven Design

Data driven design is a broad term generally referring to the use of evidence (data) when making design decisions. There are varying opinions of how much influence data should have on design, but it is becoming increasingly accepted that evidence should be considered when making decisions that impact user experience. As organizations become more metrics-driven across functions, designers too are expected to be able to quantify and validate their decisions.

The term ["data-informed design"](https://www.oreilly.com/design/free/data-informed-product-design.csp) is increasing in usage as designers and product organizations at large come to terms with the fact that data does not exist in a vacuum, and cannot be relied on as a sole source of truth in design. The shift in terminology towards "informed" rather than "driven" is indicative of a sort of correction in design thinking (lowercase intended), one in which it is acknowledged that data should help guide the direction of a design, but cannot be relied on to make decisions entirely.


#### More Information:

- [Six Myths About Data-Driven Design](https://uxmag.com/articles/six-myths-about-data-driven-design)
- [Netflix's Data-Driven Strategy Strengthens Claim For 'Best Original Content' In 2018](https://www.forbes.com/sites/kristinwestcottgrant/2018/05/28/netflixs-data-driven-strategy-strengthens-lead-for-best-original-content-in-2018/#a1804513a94e)
- [When Data Isn't Enough](https://medium.com/@chrism_14039/when-data-isnt-enough-c687ded0fd2b)
- Disambiguation: ["Responsibility-driven design (Data driven design) - programming"](https://en.wikipedia.org/wiki/Responsibility-driven_design)
