---
title: Heuristic Review
---
## Heuristic Review

A Heuristic Review is centered around a set of heuristics: best practices agreed upon by industry experts. In a heuristic review, an evaluator will judge the design against a given set of heuristics, and attempt to identify any issues with the design before recruiting actual users to test the design. For example, take a look at [Jakob Nielsen's 10 Usability Heuristics](https://www.nngroup.com/articles/ten-usability-heuristics/).

A heuristic review can be conducted by anyone. An industry expert will likely identify more issues than a novice, but a novice can use this method just as easily. Furthermore, a group of evaluators can identify a unique subset of issues; together forming a larger set of issues compared to a single novice.

When conducting a heuristic review, the evaluator should take care to search only for issues relating to the set of heuristics. This method won't necessarily provide any design breakthroughs, but it offers a quick and efficient way to detect critical missing pieces in a design.

A heuristic review should take place when low-fidelity mockups are available, which can lead to better, more thoughtful designs which can then be shown to real users.

#### Citations
Martin, Bella, and Bruce M. Hanington. Universal methods of design 100 ways to research complex problems, develop innovative ideas, and design effective solutions. Rockport Publishers, 2012.
