---
title: Usability Testing
---
## Usability Testing

Usability testing allows a designer to evaluate how real users interact with their designs. Designers will uncover areas of the design which frustrate or confuse users the most, and these issues can be prioritized. Designers will also uncover highlights within the design, where users are pleasantly surprised or delighted.

Usability tests are designed around scenarios that the designers envision to be "typical" scenarios. These scenarios will include tasks, which are concrete actions that can be done with the design. Tasks should directly correlate to the target users' actual goals. Designers should take care not to bias users through the wording of situations or tasks.

Usability tests are usually designed around a "think-aloud protocol" technique, where a user will dictate their actions and thoughts as they interact with the design.

Designers should pay attention to the following potential issues:

1) The user understands the task, but can't complete it in time
2) The user expresses surprise or delight
3) The user expresses frustration or confusion
4) The user indicates something that doesn't make sense to them
5) The user suggests a change to the design

### Suggested Best Practices

Every organization's processes will be different, but these suggested best practices are a good reference if you're just getting started with user testing.

#### Number of users

It is important to consider the number and type of testers. 1–3 is likely too small of a test group to catch all of your key issues. Conversely, the returns are diminishing after 8–10 users have tested your design; at this point, the most important issues will have been identified consistently. You should strive to test with a diverse group of users, as different perspectives and backgrounds can drive differing outcomes that are key to note at this stage.

#### Observation methods

For best results, a facilitator and an observer should run the test. The facilitator outlines the test objectives and conveys the tasks to be done; the observer records the user's reactions to using the design. It may also be beneficial to record participants' faces and audio, as well as the screen and any finger presses within a mobile application, if applicable. This can allow for a second look to better understand why a user reacted the way they did.

#### Demonstrating value

If there is hesitation within your organization around the idea of bringing in users for testing, reinforce the greater risk of shipping an unusable product. Catching usability bugs early on saves time and money, and greatly reduces the risk of delivering painful experiences to your users.

### Citations
Martin, Bella, and Bruce M. Hanington. Universal methods of design 100 ways to research complex problems, develop innovative ideas, and design effective solutions. Rockport Publishers, 2012.

Laura Klein - [UX for Lean Startups](http://shop.oreilly.com/product/0636920026242.do)
