---
title: Progressive Web Apps
---

## Progressive Web Apps

Progressive Web Apps or "PWAs" appear to be more than just a fad, but a fundamentally different way of approaching what a website can and should be on whatever platform you are viewing it from.

PWAs can install portions of themselves onto devices for offline viewing, use service workers to deliver content as needed when a connection is available and best of all standardize certain functionality between mobile and desktop devices.

### Features

Specific features of PWAs include:

* **Responsive**
  * fits any form factor
* **Offline Capabilities**
  * progressively-enhanced with Service Workers to let them work offline
* **Native App Feel**
  * adopts a Shell & Content application model to create app navigation & interactions
* **Fresh**
  * always up-to-date thanks to service workers
* **Safe**
  * served via TLS (a Service Worker requirement) to prevent snooping
* **Discoverable**
  * identifiable as "applications" thanks to W3C Manifests and Service Worker registration scope allowing search engines to find them
* **Engaging**
  * can access the re-engagement UIs of the OS through Push Notifications
* **Easy Installation**
  * can be added to the home screen through browser-provided prompts, allowing users to "keep" apps they find most useful without the hassle of an app store
* **Linkable**
  * meaning they're zero-friction, zero-install, and easy to share
  * the social power of URLs matters

> These apps aren’t packaged and deployed through stores, they’re just websites that took all the right vitamins.<sup>1</sup>

### Progressive Enhancement

Progressive enhancement means that everyone can access the basic content and functionality of a page in any browser, and those without certain browser features may receive a reduced but still functional experience. [- Lighthouse](https://medium.com/@addyosmani/progressive-web-apps-with-react-js-part-4-site-is-progressively-enhanced-b5ad7cf7a447)<sup>2</sup>

A great analogy from [Aaron Gustafson](http://alistapart.com/article/understandingprogressiveenhancement) is that progressive enhancement (PE) is like a peanut M&M.

> "The Peanut is your content, the chocolate coating is your presentation layer and your JavaScript is the hard candy shell."

This implies that depending on the browser, the experience can change.

Service Workers are progressive enhancement friendly, meaning that if a user's browser does not support Service 
Workers, they will still be able to utilize the site, they just will not benefit from the additional functionality that PWAs offer. This can be acheived by wrapping the Service Worker code in a simple conditional statement that checks for Service Worker support within the browser.

[Example](https://developer.mozilla.org/en-US/docs/Web/API/Navigator/serviceWorker)
```
if ('serviceWorker' in navigator) {
  // Supported!
}
```

### Demo

[![Demo on Progressive Web App](http://img.youtube.com/vi/esfi7ZLibmk/0.jpg)](https://www.youtube.com/watch?v=esfi7ZLibmk "Demo on Progressive Web App")


### References

1. [Russell, Alex. "Progressive Web Apps: Escaping Tabs Without Losing Our Soul" "Infrequently Noted" Posted: June 15, 2015.](https://infrequently.org/2015/06/progressive-apps-escaping-tabs-without-losing-our-soul/)
2. [Progressive Web Apps - Google Developers](https://developers.google.com/web/progressive-web-apps/)
3. [Introduction to Progressive Web Apps - MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/Apps/Progressive/Introduction)
4. [Hume, Dean. Alan. "Progressive Web Apps: Live book"](https://livebook.manning.com/#!/book/progressive-web-apps/about-this-book/)
5. [Hofmann, Simon. "The Road to PWA - Part 1"](https://blog.simon-hofmann.org/pwa/js/2018/05/07/road-to-pwa01.html)
6. [PWA Rocks! - List of Progressive Web Apps](https://pwa.rocks/) 
