---
title: Anaconda
---

![alt text](https://www.anaconda.com/wp-content/themes/anaconda/images/logo-dark.png)

**Anaconda** is a package manager, environment manager and Python distribution software with a collection of numerous packages. Anaconda is platform-agnostic, so you can use it whether you are on Windows, macOS or Linux.
Anaconda easily creates, saves, loads and switches between environments on your system. It was initially created for Python programs, but it can package and distribute software for any language.
Anaconda, as a package manager, helps you find and install packages. If you need a package that requires a different version of Python, you do not need to switch to a different environment manager, because Anaconda is also an environment manager. With just a few commands, you can set up a totally separate environment to run that different version of Python, while continuing to run your usual version of Python in your normal environment.

## Overview

The quickest way to start using conda is to go through the
20-minute [Getting started with conda](https://conda.io/docs/user-guide/getting-started.html) guide.

The ``conda`` command is the primary interface for managing
installations of various packages. It can:

* Query and search the Anaconda package index and current
  Anaconda installation.

* Create new conda environments.

* Install and update packages into existing conda environments.

TIP: You can abbreviate many frequently used command options that
are preceded by 2 dashes (``--``) to just 1 dash and the first
letter of the option. So ``--name`` and ``-n`` are the same, and
``--envs`` and ``-e`` are the same.

For full usage of each command, including abbreviations, see
[Command reference](https://conda.io/docs/commands.html).


### Sources
1. [Anaconda Documentation](https://docs.anaconda.com/)
2. [Conda Documentation](https://conda.io/docs/)

#### More Information
- [Conda cheat sheet](https://conda.io/docs/user-guide/cheatsheet.html)
