---
title: The Python Data Structures
---
A data structure is a particular way of organizing data in a computer so that it can be used efficiently. Python comes with a robust set of inbuilt data structures. Some of the most commonly used ones are:  
* [Lists](https://docs.python.org/3/library/stdtypes.html#lists) — A sequence type where comma-separated values are ordered between square brackets and changeable.
* [Tuples](https://docs.python.org/3/library/stdtypes.html#tuples) — A sequence type where values are ordered between parentheses and unchangeable.
* [Dictionaries](https://docs.python.org/3/tutorial/datastructures.html#dictionaries) — An unordered collection that is changeable and indexed where values are held within curly braces in *key: value* pairs.  

Majorly, the data structures can be divided into two categories:  
* Mutable — A mutable data structure is a structure whose state can  be modified after it is created. Python Lists and Dictionaries are mutable.  
* Immutable — An immutable data structure can't be modified. Example: Once a tuple is created, we can't update the values inside it.  

## Reference:

[Python Data Structures](https://docs.python.org/3.7/tutorial/datastructures.html)
