---
title: Python Numeric Types
---
The <a href='https://docs.python.org/3/library/stdtypes.html#numeric-types-int-float-complex' target='_blank' rel='nofollow'>numeric types</a> for Python are:

*   integers (`int`)
#### Examples:

```py
print(1)
print(100)
print(8435367)
```
*   floating point numbers (`float`)
    *   <a href='https://docs.python.org/3/library/functions.html#float' target='_blank' rel='nofollow'>constructor</a>
#### Examples:

```py
print(1.5)
print(46.84)
print(84357.435)
```
*   complex numbers
    *   <a href='https://docs.python.org/3/library/functions.html#complex' target='_blank' rel='nofollow'>constructor</a>

The standard library adds numeric types for

*   <a href='https://docs.python.org/3/library/fractions.html#module-fractions' target='_blank' rel='nofollow'>fractions</a>
*   <a href='https://docs.python.org/3/library/decimal.html#module-decimal' target='_blank' rel='nofollow'>decimals</a>

Numeric objects are created from literals or as the result of functions and operators. The syntax for numeric literals is well <a href='https://docs.python.org/3/reference/lexical_analysis.html#numeric-literals' target='_blank' rel='nofollow'>documented</a>.
